// DO NOT EDIT.
// swift-format-ignore-file
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: FlightSql.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
// <p>
// http://www.apache.org/licenses/LICENSE-2.0
// <p>
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import Foundation
import SwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: SwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: SwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

/// Options for CommandGetSqlInfo.
enum Arrow_Flight_Protocol_Sql_SqlInfo: SwiftProtobuf.Enum {
  typealias RawValue = Int

  /// Retrieves a UTF-8 string with the name of the Flight SQL Server.
  case flightSqlServerName // = 0

  /// Retrieves a UTF-8 string with the native version of the Flight SQL Server.
  case flightSqlServerVersion // = 1

  /// Retrieves a UTF-8 string with the Arrow format version of the Flight SQL Server.
  case flightSqlServerArrowVersion // = 2

  ///
  /// Retrieves a boolean value indicating whether the Flight SQL Server is read only.
  ///
  /// Returns:
  /// - false: if read-write
  /// - true: if read only
  case flightSqlServerReadOnly // = 3

  ///
  /// Retrieves a boolean value indicating whether the Flight SQL Server supports executing
  /// SQL queries.
  ///
  /// Note that the absence of this info (as opposed to a false value) does not necessarily
  /// mean that SQL is not supported, as this property was not originally defined.
  case flightSqlServerSql // = 4

  ///
  /// Retrieves a boolean value indicating whether the Flight SQL Server supports executing
  /// Substrait plans.
  case flightSqlServerSubstrait // = 5

  ///
  /// Retrieves a string value indicating the minimum supported Substrait version, or null
  /// if Substrait is not supported.
  case flightSqlServerSubstraitMinVersion // = 6

  ///
  /// Retrieves a string value indicating the maximum supported Substrait version, or null
  /// if Substrait is not supported.
  case flightSqlServerSubstraitMaxVersion // = 7

  ///
  /// Retrieves an int32 indicating whether the Flight SQL Server supports the
  /// BeginTransaction/EndTransaction/BeginSavepoint/EndSavepoint actions.
  ///
  /// Even if this is not supported, the database may still support explicit "BEGIN
  /// TRANSACTION"/"COMMIT" SQL statements (see SQL_TRANSACTIONS_SUPPORTED); this property
  /// is only about whether the server implements the Flight SQL API endpoints.
  ///
  /// The possible values are listed in `SqlSupportedTransaction`.
  case flightSqlServerTransaction // = 8

  ///
  /// Retrieves a boolean value indicating whether the Flight SQL Server supports explicit
  /// query cancellation (the CancelQuery action).
  case flightSqlServerCancel // = 9

  ///
  /// Retrieves an int32 indicating the timeout (in milliseconds) for prepared statement handles.
  ///
  /// If 0, there is no timeout.  Servers should reset the timeout when the handle is used in a command.
  case flightSqlServerStatementTimeout // = 100

  ///
  /// Retrieves an int32 indicating the timeout (in milliseconds) for transactions, since transactions are not tied to a connection.
  ///
  /// If 0, there is no timeout.  Servers should reset the timeout when the handle is used in a command.
  case flightSqlServerTransactionTimeout // = 101

  ///
  /// Retrieves a boolean value indicating whether the Flight SQL Server supports CREATE and DROP of catalogs.
  ///
  /// Returns:
  /// - false: if it doesn't support CREATE and DROP of catalogs.
  /// - true: if it supports CREATE and DROP of catalogs.
  case sqlDdlCatalog // = 500

  ///
  /// Retrieves a boolean value indicating whether the Flight SQL Server supports CREATE and DROP of schemas.
  ///
  /// Returns:
  /// - false: if it doesn't support CREATE and DROP of schemas.
  /// - true: if it supports CREATE and DROP of schemas.
  case sqlDdlSchema // = 501

  ///
  /// Indicates whether the Flight SQL Server supports CREATE and DROP of tables.
  ///
  /// Returns:
  /// - false: if it doesn't support CREATE and DROP of tables.
  /// - true: if it supports CREATE and DROP of tables.
  case sqlDdlTable // = 502

  ///
  /// Retrieves a int32 ordinal representing the case sensitivity of catalog, table, schema and table names.
  ///
  /// The possible values are listed in `arrow.flight.protocol.sql.SqlSupportedCaseSensitivity`.
  case sqlIdentifierCase // = 503

  /// Retrieves a UTF-8 string with the supported character(s) used to surround a delimited identifier.
  case sqlIdentifierQuoteChar // = 504

  ///
  /// Retrieves a int32 describing the case sensitivity of quoted identifiers.
  ///
  /// The possible values are listed in `arrow.flight.protocol.sql.SqlSupportedCaseSensitivity`.
  case sqlQuotedIdentifierCase // = 505

  ///
  /// Retrieves a boolean value indicating whether all tables are selectable.
  ///
  /// Returns:
  /// - false: if not all tables are selectable or if none are;
  /// - true: if all tables are selectable.
  case sqlAllTablesAreSelectable // = 506

  ///
  /// Retrieves the null ordering.
  ///
  /// Returns a int32 ordinal for the null ordering being used, as described in
  /// `arrow.flight.protocol.sql.SqlNullOrdering`.
  case sqlNullOrdering // = 507

  /// Retrieves a UTF-8 string list with values of the supported keywords.
  case sqlKeywords // = 508

  /// Retrieves a UTF-8 string list with values of the supported numeric functions.
  case sqlNumericFunctions // = 509

  /// Retrieves a UTF-8 string list with values of the supported string functions.
  case sqlStringFunctions // = 510

  /// Retrieves a UTF-8 string list with values of the supported system functions.
  case sqlSystemFunctions // = 511

  /// Retrieves a UTF-8 string list with values of the supported datetime functions.
  case sqlDatetimeFunctions // = 512

  ///
  /// Retrieves the UTF-8 string that can be used to escape wildcard characters.
  /// This is the string that can be used to escape '_' or '%' in the catalog search parameters that are a pattern
  /// (and therefore use one of the wildcard characters).
  /// The '_' character represents any single character; the '%' character represents any sequence of zero or more
  /// characters.
  case sqlSearchStringEscape // = 513

  ///
  /// Retrieves a UTF-8 string with all the "extra" characters that can be used in unquoted identifier names
  /// (those beyond a-z, A-Z, 0-9 and _).
  case sqlExtraNameCharacters // = 514

  ///
  /// Retrieves a boolean value indicating whether column aliasing is supported.
  /// If so, the SQL AS clause can be used to provide names for computed columns or to provide alias names for columns
  /// as required.
  ///
  /// Returns:
  /// - false: if column aliasing is unsupported;
  /// - true: if column aliasing is supported.
  case sqlSupportsColumnAliasing // = 515

  ///
  /// Retrieves a boolean value indicating whether concatenations between null and non-null values being
  /// null are supported.
  ///
  /// - Returns:
  /// - false: if concatenations between null and non-null values being null are unsupported;
  /// - true: if concatenations between null and non-null values being null are supported.
  case sqlNullPlusNullIsNull // = 516

  ///
  /// Retrieves a map where the key is the type to convert from and the value is a list with the types to convert to,
  /// indicating the supported conversions. Each key and each item on the list value is a value to a predefined type on
  /// SqlSupportsConvert enum.
  /// The returned map will be:  map<int32, list<int32>>
  case sqlSupportsConvert // = 517

  ///
  /// Retrieves a boolean value indicating whether, when table correlation names are supported,
  /// they are restricted to being different from the names of the tables.
  ///
  /// Returns:
  /// - false: if table correlation names are unsupported;
  /// - true: if table correlation names are supported.
  case sqlSupportsTableCorrelationNames // = 518

  ///
  /// Retrieves a boolean value indicating whether, when table correlation names are supported,
  /// they are restricted to being different from the names of the tables.
  ///
  /// Returns:
  /// - false: if different table correlation names are unsupported;
  /// - true: if different table correlation names are supported
  case sqlSupportsDifferentTableCorrelationNames // = 519

  ///
  /// Retrieves a boolean value indicating whether expressions in ORDER BY lists are supported.
  ///
  /// Returns:
  /// - false: if expressions in ORDER BY are unsupported;
  /// - true: if expressions in ORDER BY are supported;
  case sqlSupportsExpressionsInOrderBy // = 520

  ///
  /// Retrieves a boolean value indicating whether using a column that is not in the SELECT statement in a GROUP BY
  /// clause is supported.
  ///
  /// Returns:
  /// - false: if using a column that is not in the SELECT statement in a GROUP BY clause is unsupported;
  /// - true: if using a column that is not in the SELECT statement in a GROUP BY clause is supported.
  case sqlSupportsOrderByUnrelated // = 521

  ///
  /// Retrieves the supported GROUP BY commands;
  ///
  /// Returns an int32 bitmask value representing the supported commands.
  /// The returned bitmask should be parsed in order to retrieve the supported commands.
  ///
  /// For instance:
  /// - return 0 (\b0)   => [] (GROUP BY is unsupported);
  /// - return 1 (\b1)   => [SQL_GROUP_BY_UNRELATED];
  /// - return 2 (\b10)  => [SQL_GROUP_BY_BEYOND_SELECT];
  /// - return 3 (\b11)  => [SQL_GROUP_BY_UNRELATED, SQL_GROUP_BY_BEYOND_SELECT].
  /// Valid GROUP BY types are described under `arrow.flight.protocol.sql.SqlSupportedGroupBy`.
  case sqlSupportedGroupBy // = 522

  ///
  /// Retrieves a boolean value indicating whether specifying a LIKE escape clause is supported.
  ///
  /// Returns:
  /// - false: if specifying a LIKE escape clause is unsupported;
  /// - true: if specifying a LIKE escape clause is supported.
  case sqlSupportsLikeEscapeClause // = 523

  ///
  /// Retrieves a boolean value indicating whether columns may be defined as non-nullable.
  ///
  /// Returns:
  /// - false: if columns cannot be defined as non-nullable;
  /// - true: if columns may be defined as non-nullable.
  case sqlSupportsNonNullableColumns // = 524

  ///
  /// Retrieves the supported SQL grammar level as per the ODBC specification.
  ///
  /// Returns an int32 bitmask value representing the supported SQL grammar level.
  /// The returned bitmask should be parsed in order to retrieve the supported grammar levels.
  ///
  /// For instance:
  /// - return 0 (\b0)   => [] (SQL grammar is unsupported);
  /// - return 1 (\b1)   => [SQL_MINIMUM_GRAMMAR];
  /// - return 2 (\b10)  => [SQL_CORE_GRAMMAR];
  /// - return 3 (\b11)  => [SQL_MINIMUM_GRAMMAR, SQL_CORE_GRAMMAR];
  /// - return 4 (\b100) => [SQL_EXTENDED_GRAMMAR];
  /// - return 5 (\b101) => [SQL_MINIMUM_GRAMMAR, SQL_EXTENDED_GRAMMAR];
  /// - return 6 (\b110) => [SQL_CORE_GRAMMAR, SQL_EXTENDED_GRAMMAR];
  /// - return 7 (\b111) => [SQL_MINIMUM_GRAMMAR, SQL_CORE_GRAMMAR, SQL_EXTENDED_GRAMMAR].
  /// Valid SQL grammar levels are described under `arrow.flight.protocol.sql.SupportedSqlGrammar`.
  case sqlSupportedGrammar // = 525

  ///
  /// Retrieves the supported ANSI92 SQL grammar level.
  ///
  /// Returns an int32 bitmask value representing the supported ANSI92 SQL grammar level.
  /// The returned bitmask should be parsed in order to retrieve the supported commands.
  ///
  /// For instance:
  /// - return 0 (\b0)   => [] (ANSI92 SQL grammar is unsupported);
  /// - return 1 (\b1)   => [ANSI92_ENTRY_SQL];
  /// - return 2 (\b10)  => [ANSI92_INTERMEDIATE_SQL];
  /// - return 3 (\b11)  => [ANSI92_ENTRY_SQL, ANSI92_INTERMEDIATE_SQL];
  /// - return 4 (\b100) => [ANSI92_FULL_SQL];
  /// - return 5 (\b101) => [ANSI92_ENTRY_SQL, ANSI92_FULL_SQL];
  /// - return 6 (\b110) => [ANSI92_INTERMEDIATE_SQL, ANSI92_FULL_SQL];
  /// - return 7 (\b111) => [ANSI92_ENTRY_SQL, ANSI92_INTERMEDIATE_SQL, ANSI92_FULL_SQL].
  /// Valid ANSI92 SQL grammar levels are described under `arrow.flight.protocol.sql.SupportedAnsi92SqlGrammarLevel`.
  case sqlAnsi92SupportedLevel // = 526

  ///
  /// Retrieves a boolean value indicating whether the SQL Integrity Enhancement Facility is supported.
  ///
  /// Returns:
  /// - false: if the SQL Integrity Enhancement Facility is supported;
  /// - true: if the SQL Integrity Enhancement Facility is supported.
  case sqlSupportsIntegrityEnhancementFacility // = 527

  ///
  /// Retrieves the support level for SQL OUTER JOINs.
  ///
  /// Returns a int32 ordinal for the SQL ordering being used, as described in
  /// `arrow.flight.protocol.sql.SqlOuterJoinsSupportLevel`.
  case sqlOuterJoinsSupportLevel // = 528

  /// Retrieves a UTF-8 string with the preferred term for "schema".
  case sqlSchemaTerm // = 529

  /// Retrieves a UTF-8 string with the preferred term for "procedure".
  case sqlProcedureTerm // = 530

  ///
  /// Retrieves a UTF-8 string with the preferred term for "catalog".
  /// If a empty string is returned its assumed that the server does NOT supports catalogs.
  case sqlCatalogTerm // = 531

  ///
  /// Retrieves a boolean value indicating whether a catalog appears at the start of a fully qualified table name.
  ///
  /// - false: if a catalog does not appear at the start of a fully qualified table name;
  /// - true: if a catalog appears at the start of a fully qualified table name.
  case sqlCatalogAtStart // = 532

  ///
  /// Retrieves the supported actions for a SQL schema.
  ///
  /// Returns an int32 bitmask value representing the supported actions for a SQL schema.
  /// The returned bitmask should be parsed in order to retrieve the supported actions for a SQL schema.
  ///
  /// For instance:
  /// - return 0 (\b0)   => [] (no supported actions for SQL schema);
  /// - return 1 (\b1)   => [SQL_ELEMENT_IN_PROCEDURE_CALLS];
  /// - return 2 (\b10)  => [SQL_ELEMENT_IN_INDEX_DEFINITIONS];
  /// - return 3 (\b11)  => [SQL_ELEMENT_IN_PROCEDURE_CALLS, SQL_ELEMENT_IN_INDEX_DEFINITIONS];
  /// - return 4 (\b100) => [SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS];
  /// - return 5 (\b101) => [SQL_ELEMENT_IN_PROCEDURE_CALLS, SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS];
  /// - return 6 (\b110) => [SQL_ELEMENT_IN_INDEX_DEFINITIONS, SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS];
  /// - return 7 (\b111) => [SQL_ELEMENT_IN_PROCEDURE_CALLS, SQL_ELEMENT_IN_INDEX_DEFINITIONS, SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS].
  /// Valid actions for a SQL schema described under `arrow.flight.protocol.sql.SqlSupportedElementActions`.
  case sqlSchemasSupportedActions // = 533

  ///
  /// Retrieves the supported actions for a SQL schema.
  ///
  /// Returns an int32 bitmask value representing the supported actions for a SQL catalog.
  /// The returned bitmask should be parsed in order to retrieve the supported actions for a SQL catalog.
  ///
  /// For instance:
  /// - return 0 (\b0)   => [] (no supported actions for SQL catalog);
  /// - return 1 (\b1)   => [SQL_ELEMENT_IN_PROCEDURE_CALLS];
  /// - return 2 (\b10)  => [SQL_ELEMENT_IN_INDEX_DEFINITIONS];
  /// - return 3 (\b11)  => [SQL_ELEMENT_IN_PROCEDURE_CALLS, SQL_ELEMENT_IN_INDEX_DEFINITIONS];
  /// - return 4 (\b100) => [SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS];
  /// - return 5 (\b101) => [SQL_ELEMENT_IN_PROCEDURE_CALLS, SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS];
  /// - return 6 (\b110) => [SQL_ELEMENT_IN_INDEX_DEFINITIONS, SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS];
  /// - return 7 (\b111) => [SQL_ELEMENT_IN_PROCEDURE_CALLS, SQL_ELEMENT_IN_INDEX_DEFINITIONS, SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS].
  /// Valid actions for a SQL catalog are described under `arrow.flight.protocol.sql.SqlSupportedElementActions`.
  case sqlCatalogsSupportedActions // = 534

  ///
  /// Retrieves the supported SQL positioned commands.
  ///
  /// Returns an int32 bitmask value representing the supported SQL positioned commands.
  /// The returned bitmask should be parsed in order to retrieve the supported SQL positioned commands.
  ///
  /// For instance:
  /// - return 0 (\b0)   => [] (no supported SQL positioned commands);
  /// - return 1 (\b1)   => [SQL_POSITIONED_DELETE];
  /// - return 2 (\b10)  => [SQL_POSITIONED_UPDATE];
  /// - return 3 (\b11)  => [SQL_POSITIONED_DELETE, SQL_POSITIONED_UPDATE].
  /// Valid SQL positioned commands are described under `arrow.flight.protocol.sql.SqlSupportedPositionedCommands`.
  case sqlSupportedPositionedCommands // = 535

  ///
  /// Retrieves a boolean value indicating whether SELECT FOR UPDATE statements are supported.
  ///
  /// Returns:
  /// - false: if SELECT FOR UPDATE statements are unsupported;
  /// - true: if SELECT FOR UPDATE statements are supported.
  case sqlSelectForUpdateSupported // = 536

  ///
  /// Retrieves a boolean value indicating whether stored procedure calls that use the stored procedure escape syntax
  /// are supported.
  ///
  /// Returns:
  /// - false: if stored procedure calls that use the stored procedure escape syntax are unsupported;
  /// - true: if stored procedure calls that use the stored procedure escape syntax are supported.
  case sqlStoredProceduresSupported // = 537

  ///
  /// Retrieves the supported SQL subqueries.
  ///
  /// Returns an int32 bitmask value representing the supported SQL subqueries.
  /// The returned bitmask should be parsed in order to retrieve the supported SQL subqueries.
  ///
  /// For instance:
  /// - return 0   (\b0)     => [] (no supported SQL subqueries);
  /// - return 1   (\b1)     => [SQL_SUBQUERIES_IN_COMPARISONS];
  /// - return 2   (\b10)    => [SQL_SUBQUERIES_IN_EXISTS];
  /// - return 3   (\b11)    => [SQL_SUBQUERIES_IN_COMPARISONS, SQL_SUBQUERIES_IN_EXISTS];
  /// - return 4   (\b100)   => [SQL_SUBQUERIES_IN_INS];
  /// - return 5   (\b101)   => [SQL_SUBQUERIES_IN_COMPARISONS, SQL_SUBQUERIES_IN_INS];
  /// - return 6   (\b110)   => [SQL_SUBQUERIES_IN_INS, SQL_SUBQUERIES_IN_EXISTS];
  /// - return 7   (\b111)   => [SQL_SUBQUERIES_IN_COMPARISONS, SQL_SUBQUERIES_IN_EXISTS, SQL_SUBQUERIES_IN_INS];
  /// - return 8   (\b1000)  => [SQL_SUBQUERIES_IN_QUANTIFIEDS];
  /// - return 9   (\b1001)  => [SQL_SUBQUERIES_IN_COMPARISONS, SQL_SUBQUERIES_IN_QUANTIFIEDS];
  /// - return 10  (\b1010)  => [SQL_SUBQUERIES_IN_EXISTS, SQL_SUBQUERIES_IN_QUANTIFIEDS];
  /// - return 11  (\b1011)  => [SQL_SUBQUERIES_IN_COMPARISONS, SQL_SUBQUERIES_IN_EXISTS, SQL_SUBQUERIES_IN_QUANTIFIEDS];
  /// - return 12  (\b1100)  => [SQL_SUBQUERIES_IN_INS, SQL_SUBQUERIES_IN_QUANTIFIEDS];
  /// - return 13  (\b1101)  => [SQL_SUBQUERIES_IN_COMPARISONS, SQL_SUBQUERIES_IN_INS, SQL_SUBQUERIES_IN_QUANTIFIEDS];
  /// - return 14  (\b1110)  => [SQL_SUBQUERIES_IN_EXISTS, SQL_SUBQUERIES_IN_INS, SQL_SUBQUERIES_IN_QUANTIFIEDS];
  /// - return 15  (\b1111)  => [SQL_SUBQUERIES_IN_COMPARISONS, SQL_SUBQUERIES_IN_EXISTS, SQL_SUBQUERIES_IN_INS, SQL_SUBQUERIES_IN_QUANTIFIEDS];
  /// - ...
  /// Valid SQL subqueries are described under `arrow.flight.protocol.sql.SqlSupportedSubqueries`.
  case sqlSupportedSubqueries // = 538

  ///
  /// Retrieves a boolean value indicating whether correlated subqueries are supported.
  ///
  /// Returns:
  /// - false: if correlated subqueries are unsupported;
  /// - true: if correlated subqueries are supported.
  case sqlCorrelatedSubqueriesSupported // = 539

  ///
  /// Retrieves the supported SQL UNIONs.
  ///
  /// Returns an int32 bitmask value representing the supported SQL UNIONs.
  /// The returned bitmask should be parsed in order to retrieve the supported SQL UNIONs.
  ///
  /// For instance:
  /// - return 0 (\b0)   => [] (no supported SQL positioned commands);
  /// - return 1 (\b1)   => [SQL_UNION];
  /// - return 2 (\b10)  => [SQL_UNION_ALL];
  /// - return 3 (\b11)  => [SQL_UNION, SQL_UNION_ALL].
  /// Valid SQL positioned commands are described under `arrow.flight.protocol.sql.SqlSupportedUnions`.
  case sqlSupportedUnions // = 540

  /// Retrieves a int64 value representing the maximum number of hex characters allowed in an inline binary literal.
  case sqlMaxBinaryLiteralLength // = 541

  /// Retrieves a int64 value representing the maximum number of characters allowed for a character literal.
  case sqlMaxCharLiteralLength // = 542

  /// Retrieves a int64 value representing the maximum number of characters allowed for a column name.
  case sqlMaxColumnNameLength // = 543

  /// Retrieves a int64 value representing the maximum number of columns allowed in a GROUP BY clause.
  case sqlMaxColumnsInGroupBy // = 544

  /// Retrieves a int64 value representing the maximum number of columns allowed in an index.
  case sqlMaxColumnsInIndex // = 545

  /// Retrieves a int64 value representing the maximum number of columns allowed in an ORDER BY clause.
  case sqlMaxColumnsInOrderBy // = 546

  /// Retrieves a int64 value representing the maximum number of columns allowed in a SELECT list.
  case sqlMaxColumnsInSelect // = 547

  /// Retrieves a int64 value representing the maximum number of columns allowed in a table.
  case sqlMaxColumnsInTable // = 548

  /// Retrieves a int64 value representing the maximum number of concurrent connections possible.
  case sqlMaxConnections // = 549

  /// Retrieves a int64 value the maximum number of characters allowed in a cursor name.
  case sqlMaxCursorNameLength // = 550

  ///
  /// Retrieves a int64 value representing the maximum number of bytes allowed for an index,
  /// including all of the parts of the index.
  case sqlMaxIndexLength // = 551

  /// Retrieves a int64 value representing the maximum number of characters allowed in a schema name.
  case sqlDbSchemaNameLength // = 552

  /// Retrieves a int64 value representing the maximum number of characters allowed in a procedure name.
  case sqlMaxProcedureNameLength // = 553

  /// Retrieves a int64 value representing the maximum number of characters allowed in a catalog name.
  case sqlMaxCatalogNameLength // = 554

  /// Retrieves a int64 value representing the maximum number of bytes allowed in a single row.
  case sqlMaxRowSize // = 555

  ///
  /// Retrieves a boolean indicating whether the return value for the JDBC method getMaxRowSize includes the SQL
  /// data types LONGVARCHAR and LONGVARBINARY.
  ///
  /// Returns:
  /// - false: if return value for the JDBC method getMaxRowSize does
  ///          not include the SQL data types LONGVARCHAR and LONGVARBINARY;
  /// - true: if return value for the JDBC method getMaxRowSize includes
  ///         the SQL data types LONGVARCHAR and LONGVARBINARY.
  case sqlMaxRowSizeIncludesBlobs // = 556

  ///
  /// Retrieves a int64 value representing the maximum number of characters allowed for an SQL statement;
  /// a result of 0 (zero) means that there is no limit or the limit is not known.
  case sqlMaxStatementLength // = 557

  /// Retrieves a int64 value representing the maximum number of active statements that can be open at the same time.
  case sqlMaxStatements // = 558

  /// Retrieves a int64 value representing the maximum number of characters allowed in a table name.
  case sqlMaxTableNameLength // = 559

  /// Retrieves a int64 value representing the maximum number of tables allowed in a SELECT statement.
  case sqlMaxTablesInSelect // = 560

  /// Retrieves a int64 value representing the maximum number of characters allowed in a user name.
  case sqlMaxUsernameLength // = 561

  ///
  /// Retrieves this database's default transaction isolation level as described in
  /// `arrow.flight.protocol.sql.SqlTransactionIsolationLevel`.
  ///
  /// Returns a int32 ordinal for the SQL transaction isolation level.
  case sqlDefaultTransactionIsolation // = 562

  ///
  /// Retrieves a boolean value indicating whether transactions are supported. If not, invoking the method commit is a
  /// noop, and the isolation level is `arrow.flight.protocol.sql.SqlTransactionIsolationLevel.TRANSACTION_NONE`.
  ///
  /// Returns:
  /// - false: if transactions are unsupported;
  /// - true: if transactions are supported.
  case sqlTransactionsSupported // = 563

  ///
  /// Retrieves the supported transactions isolation levels.
  ///
  /// Returns an int32 bitmask value representing the supported transactions isolation levels.
  /// The returned bitmask should be parsed in order to retrieve the supported transactions isolation levels.
  ///
  /// For instance:
  /// - return 0   (\b0)     => [] (no supported SQL transactions isolation levels);
  /// - return 1   (\b1)     => [SQL_TRANSACTION_NONE];
  /// - return 2   (\b10)    => [SQL_TRANSACTION_READ_UNCOMMITTED];
  /// - return 3   (\b11)    => [SQL_TRANSACTION_NONE, SQL_TRANSACTION_READ_UNCOMMITTED];
  /// - return 4   (\b100)   => [SQL_TRANSACTION_REPEATABLE_READ];
  /// - return 5   (\b101)   => [SQL_TRANSACTION_NONE, SQL_TRANSACTION_REPEATABLE_READ];
  /// - return 6   (\b110)   => [SQL_TRANSACTION_READ_UNCOMMITTED, SQL_TRANSACTION_REPEATABLE_READ];
  /// - return 7   (\b111)   => [SQL_TRANSACTION_NONE, SQL_TRANSACTION_READ_UNCOMMITTED, SQL_TRANSACTION_REPEATABLE_READ];
  /// - return 8   (\b1000)  => [SQL_TRANSACTION_REPEATABLE_READ];
  /// - return 9   (\b1001)  => [SQL_TRANSACTION_NONE, SQL_TRANSACTION_REPEATABLE_READ];
  /// - return 10  (\b1010)  => [SQL_TRANSACTION_READ_UNCOMMITTED, SQL_TRANSACTION_REPEATABLE_READ];
  /// - return 11  (\b1011)  => [SQL_TRANSACTION_NONE, SQL_TRANSACTION_READ_UNCOMMITTED, SQL_TRANSACTION_REPEATABLE_READ];
  /// - return 12  (\b1100)  => [SQL_TRANSACTION_REPEATABLE_READ, SQL_TRANSACTION_REPEATABLE_READ];
  /// - return 13  (\b1101)  => [SQL_TRANSACTION_NONE, SQL_TRANSACTION_REPEATABLE_READ, SQL_TRANSACTION_REPEATABLE_READ];
  /// - return 14  (\b1110)  => [SQL_TRANSACTION_READ_UNCOMMITTED, SQL_TRANSACTION_REPEATABLE_READ, SQL_TRANSACTION_REPEATABLE_READ];
  /// - return 15  (\b1111)  => [SQL_TRANSACTION_NONE, SQL_TRANSACTION_READ_UNCOMMITTED, SQL_TRANSACTION_REPEATABLE_READ, SQL_TRANSACTION_REPEATABLE_READ];
  /// - return 16  (\b10000) => [SQL_TRANSACTION_SERIALIZABLE];
  /// - ...
  /// Valid SQL positioned commands are described under `arrow.flight.protocol.sql.SqlTransactionIsolationLevel`.
  case sqlSupportedTransactionsIsolationLevels // = 564

  ///
  /// Retrieves a boolean value indicating whether a data definition statement within a transaction forces
  /// the transaction to commit.
  ///
  /// Returns:
  /// - false: if a data definition statement within a transaction does not force the transaction to commit;
  /// - true: if a data definition statement within a transaction forces the transaction to commit.
  case sqlDataDefinitionCausesTransactionCommit // = 565

  ///
  /// Retrieves a boolean value indicating whether a data definition statement within a transaction is ignored.
  ///
  /// Returns:
  /// - false: if a data definition statement within a transaction is taken into account;
  /// - true: a data definition statement within a transaction is ignored.
  case sqlDataDefinitionsInTransactionsIgnored // = 566

  ///
  /// Retrieves an int32 bitmask value representing the supported result set types.
  /// The returned bitmask should be parsed in order to retrieve the supported result set types.
  ///
  /// For instance:
  /// - return 0   (\b0)     => [] (no supported result set types);
  /// - return 1   (\b1)     => [SQL_RESULT_SET_TYPE_UNSPECIFIED];
  /// - return 2   (\b10)    => [SQL_RESULT_SET_TYPE_FORWARD_ONLY];
  /// - return 3   (\b11)    => [SQL_RESULT_SET_TYPE_UNSPECIFIED, SQL_RESULT_SET_TYPE_FORWARD_ONLY];
  /// - return 4   (\b100)   => [SQL_RESULT_SET_TYPE_SCROLL_INSENSITIVE];
  /// - return 5   (\b101)   => [SQL_RESULT_SET_TYPE_UNSPECIFIED, SQL_RESULT_SET_TYPE_SCROLL_INSENSITIVE];
  /// - return 6   (\b110)   => [SQL_RESULT_SET_TYPE_FORWARD_ONLY, SQL_RESULT_SET_TYPE_SCROLL_INSENSITIVE];
  /// - return 7   (\b111)   => [SQL_RESULT_SET_TYPE_UNSPECIFIED, SQL_RESULT_SET_TYPE_FORWARD_ONLY, SQL_RESULT_SET_TYPE_SCROLL_INSENSITIVE];
  /// - return 8   (\b1000)  => [SQL_RESULT_SET_TYPE_SCROLL_SENSITIVE];
  /// - ...
  /// Valid result set types are described under `arrow.flight.protocol.sql.SqlSupportedResultSetType`.
  case sqlSupportedResultSetTypes // = 567

  ///
  /// Returns an int32 bitmask value concurrency types supported for
  /// `arrow.flight.protocol.sql.SqlSupportedResultSetType.SQL_RESULT_SET_TYPE_UNSPECIFIED`.
  ///
  /// For instance:
  /// - return 0 (\b0)   => [] (no supported concurrency types for this result set type)
  /// - return 1 (\b1)   => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED]
  /// - return 2 (\b10)  => [SQL_RESULT_SET_CONCURRENCY_READ_ONLY]
  /// - return 3 (\b11)  => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_READ_ONLY]
  /// - return 4 (\b100) => [SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
  /// - return 5 (\b101) => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
  /// - return 6 (\b110)  => [SQL_RESULT_SET_CONCURRENCY_READ_ONLY, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
  /// - return 7 (\b111)  => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_READ_ONLY, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
  /// Valid result set types are described under `arrow.flight.protocol.sql.SqlSupportedResultSetConcurrency`.
  case sqlSupportedConcurrenciesForResultSetUnspecified // = 568

  ///
  /// Returns an int32 bitmask value concurrency types supported for
  /// `arrow.flight.protocol.sql.SqlSupportedResultSetType.SQL_RESULT_SET_TYPE_FORWARD_ONLY`.
  ///
  /// For instance:
  /// - return 0 (\b0)   => [] (no supported concurrency types for this result set type)
  /// - return 1 (\b1)   => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED]
  /// - return 2 (\b10)  => [SQL_RESULT_SET_CONCURRENCY_READ_ONLY]
  /// - return 3 (\b11)  => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_READ_ONLY]
  /// - return 4 (\b100) => [SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
  /// - return 5 (\b101) => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
  /// - return 6 (\b110)  => [SQL_RESULT_SET_CONCURRENCY_READ_ONLY, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
  /// - return 7 (\b111)  => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_READ_ONLY, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
  /// Valid result set types are described under `arrow.flight.protocol.sql.SqlSupportedResultSetConcurrency`.
  case sqlSupportedConcurrenciesForResultSetForwardOnly // = 569

  ///
  /// Returns an int32 bitmask value concurrency types supported for
  /// `arrow.flight.protocol.sql.SqlSupportedResultSetType.SQL_RESULT_SET_TYPE_SCROLL_SENSITIVE`.
  ///
  /// For instance:
  /// - return 0 (\b0)   => [] (no supported concurrency types for this result set type)
  /// - return 1 (\b1)   => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED]
  /// - return 2 (\b10)  => [SQL_RESULT_SET_CONCURRENCY_READ_ONLY]
  /// - return 3 (\b11)  => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_READ_ONLY]
  /// - return 4 (\b100) => [SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
  /// - return 5 (\b101) => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
  /// - return 6 (\b110)  => [SQL_RESULT_SET_CONCURRENCY_READ_ONLY, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
  /// - return 7 (\b111)  => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_READ_ONLY, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
  /// Valid result set types are described under `arrow.flight.protocol.sql.SqlSupportedResultSetConcurrency`.
  case sqlSupportedConcurrenciesForResultSetScrollSensitive // = 570

  ///
  /// Returns an int32 bitmask value concurrency types supported for
  /// `arrow.flight.protocol.sql.SqlSupportedResultSetType.SQL_RESULT_SET_TYPE_SCROLL_INSENSITIVE`.
  ///
  /// For instance:
  /// - return 0 (\b0)   => [] (no supported concurrency types for this result set type)
  /// - return 1 (\b1)   => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED]
  /// - return 2 (\b10)  => [SQL_RESULT_SET_CONCURRENCY_READ_ONLY]
  /// - return 3 (\b11)  => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_READ_ONLY]
  /// - return 4 (\b100) => [SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
  /// - return 5 (\b101) => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
  /// - return 6 (\b110)  => [SQL_RESULT_SET_CONCURRENCY_READ_ONLY, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
  /// - return 7 (\b111)  => [SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED, SQL_RESULT_SET_CONCURRENCY_READ_ONLY, SQL_RESULT_SET_CONCURRENCY_UPDATABLE]
  /// Valid result set types are described under `arrow.flight.protocol.sql.SqlSupportedResultSetConcurrency`.
  case sqlSupportedConcurrenciesForResultSetScrollInsensitive // = 571

  ///
  /// Retrieves a boolean value indicating whether this database supports batch updates.
  ///
  /// - false: if this database does not support batch updates;
  /// - true: if this database supports batch updates.
  case sqlBatchUpdatesSupported // = 572

  ///
  /// Retrieves a boolean value indicating whether this database supports savepoints.
  ///
  /// Returns:
  /// - false: if this database does not support savepoints;
  /// - true: if this database supports savepoints.
  case sqlSavepointsSupported // = 573

  ///
  /// Retrieves a boolean value indicating whether named parameters are supported in callable statements.
  ///
  /// Returns:
  /// - false: if named parameters in callable statements are unsupported;
  /// - true: if named parameters in callable statements are supported.
  case sqlNamedParametersSupported // = 574

  ///
  /// Retrieves a boolean value indicating whether updates made to a LOB are made on a copy or directly to the LOB.
  ///
  /// Returns:
  /// - false: if updates made to a LOB are made directly to the LOB;
  /// - true: if updates made to a LOB are made on a copy.
  case sqlLocatorsUpdateCopy // = 575

  ///
  /// Retrieves a boolean value indicating whether invoking user-defined or vendor functions
  /// using the stored procedure escape syntax is supported.
  ///
  /// Returns:
  /// - false: if invoking user-defined or vendor functions using the stored procedure escape syntax is unsupported;
  /// - true: if invoking user-defined or vendor functions using the stored procedure escape syntax is supported.
  case sqlStoredFunctionsUsingCallSyntaxSupported // = 576
  case UNRECOGNIZED(Int)

  init() {
    self = .flightSqlServerName
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .flightSqlServerName
    case 1: self = .flightSqlServerVersion
    case 2: self = .flightSqlServerArrowVersion
    case 3: self = .flightSqlServerReadOnly
    case 4: self = .flightSqlServerSql
    case 5: self = .flightSqlServerSubstrait
    case 6: self = .flightSqlServerSubstraitMinVersion
    case 7: self = .flightSqlServerSubstraitMaxVersion
    case 8: self = .flightSqlServerTransaction
    case 9: self = .flightSqlServerCancel
    case 100: self = .flightSqlServerStatementTimeout
    case 101: self = .flightSqlServerTransactionTimeout
    case 500: self = .sqlDdlCatalog
    case 501: self = .sqlDdlSchema
    case 502: self = .sqlDdlTable
    case 503: self = .sqlIdentifierCase
    case 504: self = .sqlIdentifierQuoteChar
    case 505: self = .sqlQuotedIdentifierCase
    case 506: self = .sqlAllTablesAreSelectable
    case 507: self = .sqlNullOrdering
    case 508: self = .sqlKeywords
    case 509: self = .sqlNumericFunctions
    case 510: self = .sqlStringFunctions
    case 511: self = .sqlSystemFunctions
    case 512: self = .sqlDatetimeFunctions
    case 513: self = .sqlSearchStringEscape
    case 514: self = .sqlExtraNameCharacters
    case 515: self = .sqlSupportsColumnAliasing
    case 516: self = .sqlNullPlusNullIsNull
    case 517: self = .sqlSupportsConvert
    case 518: self = .sqlSupportsTableCorrelationNames
    case 519: self = .sqlSupportsDifferentTableCorrelationNames
    case 520: self = .sqlSupportsExpressionsInOrderBy
    case 521: self = .sqlSupportsOrderByUnrelated
    case 522: self = .sqlSupportedGroupBy
    case 523: self = .sqlSupportsLikeEscapeClause
    case 524: self = .sqlSupportsNonNullableColumns
    case 525: self = .sqlSupportedGrammar
    case 526: self = .sqlAnsi92SupportedLevel
    case 527: self = .sqlSupportsIntegrityEnhancementFacility
    case 528: self = .sqlOuterJoinsSupportLevel
    case 529: self = .sqlSchemaTerm
    case 530: self = .sqlProcedureTerm
    case 531: self = .sqlCatalogTerm
    case 532: self = .sqlCatalogAtStart
    case 533: self = .sqlSchemasSupportedActions
    case 534: self = .sqlCatalogsSupportedActions
    case 535: self = .sqlSupportedPositionedCommands
    case 536: self = .sqlSelectForUpdateSupported
    case 537: self = .sqlStoredProceduresSupported
    case 538: self = .sqlSupportedSubqueries
    case 539: self = .sqlCorrelatedSubqueriesSupported
    case 540: self = .sqlSupportedUnions
    case 541: self = .sqlMaxBinaryLiteralLength
    case 542: self = .sqlMaxCharLiteralLength
    case 543: self = .sqlMaxColumnNameLength
    case 544: self = .sqlMaxColumnsInGroupBy
    case 545: self = .sqlMaxColumnsInIndex
    case 546: self = .sqlMaxColumnsInOrderBy
    case 547: self = .sqlMaxColumnsInSelect
    case 548: self = .sqlMaxColumnsInTable
    case 549: self = .sqlMaxConnections
    case 550: self = .sqlMaxCursorNameLength
    case 551: self = .sqlMaxIndexLength
    case 552: self = .sqlDbSchemaNameLength
    case 553: self = .sqlMaxProcedureNameLength
    case 554: self = .sqlMaxCatalogNameLength
    case 555: self = .sqlMaxRowSize
    case 556: self = .sqlMaxRowSizeIncludesBlobs
    case 557: self = .sqlMaxStatementLength
    case 558: self = .sqlMaxStatements
    case 559: self = .sqlMaxTableNameLength
    case 560: self = .sqlMaxTablesInSelect
    case 561: self = .sqlMaxUsernameLength
    case 562: self = .sqlDefaultTransactionIsolation
    case 563: self = .sqlTransactionsSupported
    case 564: self = .sqlSupportedTransactionsIsolationLevels
    case 565: self = .sqlDataDefinitionCausesTransactionCommit
    case 566: self = .sqlDataDefinitionsInTransactionsIgnored
    case 567: self = .sqlSupportedResultSetTypes
    case 568: self = .sqlSupportedConcurrenciesForResultSetUnspecified
    case 569: self = .sqlSupportedConcurrenciesForResultSetForwardOnly
    case 570: self = .sqlSupportedConcurrenciesForResultSetScrollSensitive
    case 571: self = .sqlSupportedConcurrenciesForResultSetScrollInsensitive
    case 572: self = .sqlBatchUpdatesSupported
    case 573: self = .sqlSavepointsSupported
    case 574: self = .sqlNamedParametersSupported
    case 575: self = .sqlLocatorsUpdateCopy
    case 576: self = .sqlStoredFunctionsUsingCallSyntaxSupported
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .flightSqlServerName: return 0
    case .flightSqlServerVersion: return 1
    case .flightSqlServerArrowVersion: return 2
    case .flightSqlServerReadOnly: return 3
    case .flightSqlServerSql: return 4
    case .flightSqlServerSubstrait: return 5
    case .flightSqlServerSubstraitMinVersion: return 6
    case .flightSqlServerSubstraitMaxVersion: return 7
    case .flightSqlServerTransaction: return 8
    case .flightSqlServerCancel: return 9
    case .flightSqlServerStatementTimeout: return 100
    case .flightSqlServerTransactionTimeout: return 101
    case .sqlDdlCatalog: return 500
    case .sqlDdlSchema: return 501
    case .sqlDdlTable: return 502
    case .sqlIdentifierCase: return 503
    case .sqlIdentifierQuoteChar: return 504
    case .sqlQuotedIdentifierCase: return 505
    case .sqlAllTablesAreSelectable: return 506
    case .sqlNullOrdering: return 507
    case .sqlKeywords: return 508
    case .sqlNumericFunctions: return 509
    case .sqlStringFunctions: return 510
    case .sqlSystemFunctions: return 511
    case .sqlDatetimeFunctions: return 512
    case .sqlSearchStringEscape: return 513
    case .sqlExtraNameCharacters: return 514
    case .sqlSupportsColumnAliasing: return 515
    case .sqlNullPlusNullIsNull: return 516
    case .sqlSupportsConvert: return 517
    case .sqlSupportsTableCorrelationNames: return 518
    case .sqlSupportsDifferentTableCorrelationNames: return 519
    case .sqlSupportsExpressionsInOrderBy: return 520
    case .sqlSupportsOrderByUnrelated: return 521
    case .sqlSupportedGroupBy: return 522
    case .sqlSupportsLikeEscapeClause: return 523
    case .sqlSupportsNonNullableColumns: return 524
    case .sqlSupportedGrammar: return 525
    case .sqlAnsi92SupportedLevel: return 526
    case .sqlSupportsIntegrityEnhancementFacility: return 527
    case .sqlOuterJoinsSupportLevel: return 528
    case .sqlSchemaTerm: return 529
    case .sqlProcedureTerm: return 530
    case .sqlCatalogTerm: return 531
    case .sqlCatalogAtStart: return 532
    case .sqlSchemasSupportedActions: return 533
    case .sqlCatalogsSupportedActions: return 534
    case .sqlSupportedPositionedCommands: return 535
    case .sqlSelectForUpdateSupported: return 536
    case .sqlStoredProceduresSupported: return 537
    case .sqlSupportedSubqueries: return 538
    case .sqlCorrelatedSubqueriesSupported: return 539
    case .sqlSupportedUnions: return 540
    case .sqlMaxBinaryLiteralLength: return 541
    case .sqlMaxCharLiteralLength: return 542
    case .sqlMaxColumnNameLength: return 543
    case .sqlMaxColumnsInGroupBy: return 544
    case .sqlMaxColumnsInIndex: return 545
    case .sqlMaxColumnsInOrderBy: return 546
    case .sqlMaxColumnsInSelect: return 547
    case .sqlMaxColumnsInTable: return 548
    case .sqlMaxConnections: return 549
    case .sqlMaxCursorNameLength: return 550
    case .sqlMaxIndexLength: return 551
    case .sqlDbSchemaNameLength: return 552
    case .sqlMaxProcedureNameLength: return 553
    case .sqlMaxCatalogNameLength: return 554
    case .sqlMaxRowSize: return 555
    case .sqlMaxRowSizeIncludesBlobs: return 556
    case .sqlMaxStatementLength: return 557
    case .sqlMaxStatements: return 558
    case .sqlMaxTableNameLength: return 559
    case .sqlMaxTablesInSelect: return 560
    case .sqlMaxUsernameLength: return 561
    case .sqlDefaultTransactionIsolation: return 562
    case .sqlTransactionsSupported: return 563
    case .sqlSupportedTransactionsIsolationLevels: return 564
    case .sqlDataDefinitionCausesTransactionCommit: return 565
    case .sqlDataDefinitionsInTransactionsIgnored: return 566
    case .sqlSupportedResultSetTypes: return 567
    case .sqlSupportedConcurrenciesForResultSetUnspecified: return 568
    case .sqlSupportedConcurrenciesForResultSetForwardOnly: return 569
    case .sqlSupportedConcurrenciesForResultSetScrollSensitive: return 570
    case .sqlSupportedConcurrenciesForResultSetScrollInsensitive: return 571
    case .sqlBatchUpdatesSupported: return 572
    case .sqlSavepointsSupported: return 573
    case .sqlNamedParametersSupported: return 574
    case .sqlLocatorsUpdateCopy: return 575
    case .sqlStoredFunctionsUsingCallSyntaxSupported: return 576
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_SqlInfo: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_SqlInfo] = [
    .flightSqlServerName,
    .flightSqlServerVersion,
    .flightSqlServerArrowVersion,
    .flightSqlServerReadOnly,
    .flightSqlServerSql,
    .flightSqlServerSubstrait,
    .flightSqlServerSubstraitMinVersion,
    .flightSqlServerSubstraitMaxVersion,
    .flightSqlServerTransaction,
    .flightSqlServerCancel,
    .flightSqlServerStatementTimeout,
    .flightSqlServerTransactionTimeout,
    .sqlDdlCatalog,
    .sqlDdlSchema,
    .sqlDdlTable,
    .sqlIdentifierCase,
    .sqlIdentifierQuoteChar,
    .sqlQuotedIdentifierCase,
    .sqlAllTablesAreSelectable,
    .sqlNullOrdering,
    .sqlKeywords,
    .sqlNumericFunctions,
    .sqlStringFunctions,
    .sqlSystemFunctions,
    .sqlDatetimeFunctions,
    .sqlSearchStringEscape,
    .sqlExtraNameCharacters,
    .sqlSupportsColumnAliasing,
    .sqlNullPlusNullIsNull,
    .sqlSupportsConvert,
    .sqlSupportsTableCorrelationNames,
    .sqlSupportsDifferentTableCorrelationNames,
    .sqlSupportsExpressionsInOrderBy,
    .sqlSupportsOrderByUnrelated,
    .sqlSupportedGroupBy,
    .sqlSupportsLikeEscapeClause,
    .sqlSupportsNonNullableColumns,
    .sqlSupportedGrammar,
    .sqlAnsi92SupportedLevel,
    .sqlSupportsIntegrityEnhancementFacility,
    .sqlOuterJoinsSupportLevel,
    .sqlSchemaTerm,
    .sqlProcedureTerm,
    .sqlCatalogTerm,
    .sqlCatalogAtStart,
    .sqlSchemasSupportedActions,
    .sqlCatalogsSupportedActions,
    .sqlSupportedPositionedCommands,
    .sqlSelectForUpdateSupported,
    .sqlStoredProceduresSupported,
    .sqlSupportedSubqueries,
    .sqlCorrelatedSubqueriesSupported,
    .sqlSupportedUnions,
    .sqlMaxBinaryLiteralLength,
    .sqlMaxCharLiteralLength,
    .sqlMaxColumnNameLength,
    .sqlMaxColumnsInGroupBy,
    .sqlMaxColumnsInIndex,
    .sqlMaxColumnsInOrderBy,
    .sqlMaxColumnsInSelect,
    .sqlMaxColumnsInTable,
    .sqlMaxConnections,
    .sqlMaxCursorNameLength,
    .sqlMaxIndexLength,
    .sqlDbSchemaNameLength,
    .sqlMaxProcedureNameLength,
    .sqlMaxCatalogNameLength,
    .sqlMaxRowSize,
    .sqlMaxRowSizeIncludesBlobs,
    .sqlMaxStatementLength,
    .sqlMaxStatements,
    .sqlMaxTableNameLength,
    .sqlMaxTablesInSelect,
    .sqlMaxUsernameLength,
    .sqlDefaultTransactionIsolation,
    .sqlTransactionsSupported,
    .sqlSupportedTransactionsIsolationLevels,
    .sqlDataDefinitionCausesTransactionCommit,
    .sqlDataDefinitionsInTransactionsIgnored,
    .sqlSupportedResultSetTypes,
    .sqlSupportedConcurrenciesForResultSetUnspecified,
    .sqlSupportedConcurrenciesForResultSetForwardOnly,
    .sqlSupportedConcurrenciesForResultSetScrollSensitive,
    .sqlSupportedConcurrenciesForResultSetScrollInsensitive,
    .sqlBatchUpdatesSupported,
    .sqlSavepointsSupported,
    .sqlNamedParametersSupported,
    .sqlLocatorsUpdateCopy,
    .sqlStoredFunctionsUsingCallSyntaxSupported,
  ]
}

#endif  // swift(>=4.2)

/// The level of support for Flight SQL transaction RPCs.
enum Arrow_Flight_Protocol_Sql_SqlSupportedTransaction: SwiftProtobuf.Enum {
  typealias RawValue = Int

  /// Unknown/not indicated/no support
  case none // = 0

  /// Transactions, but not savepoints.
  /// A savepoint is a mark within a transaction that can be individually
  /// rolled back to. Not all databases support savepoints.
  case transaction // = 1

  /// Transactions and savepoints
  case savepoint // = 2
  case UNRECOGNIZED(Int)

  init() {
    self = .none
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .none
    case 1: self = .transaction
    case 2: self = .savepoint
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .none: return 0
    case .transaction: return 1
    case .savepoint: return 2
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_SqlSupportedTransaction: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_SqlSupportedTransaction] = [
    .none,
    .transaction,
    .savepoint,
  ]
}

#endif  // swift(>=4.2)

enum Arrow_Flight_Protocol_Sql_SqlSupportedCaseSensitivity: SwiftProtobuf.Enum {
  typealias RawValue = Int
  case sqlCaseSensitivityUnknown // = 0
  case sqlCaseSensitivityCaseInsensitive // = 1
  case sqlCaseSensitivityUppercase // = 2
  case sqlCaseSensitivityLowercase // = 3
  case UNRECOGNIZED(Int)

  init() {
    self = .sqlCaseSensitivityUnknown
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .sqlCaseSensitivityUnknown
    case 1: self = .sqlCaseSensitivityCaseInsensitive
    case 2: self = .sqlCaseSensitivityUppercase
    case 3: self = .sqlCaseSensitivityLowercase
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .sqlCaseSensitivityUnknown: return 0
    case .sqlCaseSensitivityCaseInsensitive: return 1
    case .sqlCaseSensitivityUppercase: return 2
    case .sqlCaseSensitivityLowercase: return 3
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_SqlSupportedCaseSensitivity: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_SqlSupportedCaseSensitivity] = [
    .sqlCaseSensitivityUnknown,
    .sqlCaseSensitivityCaseInsensitive,
    .sqlCaseSensitivityUppercase,
    .sqlCaseSensitivityLowercase,
  ]
}

#endif  // swift(>=4.2)

enum Arrow_Flight_Protocol_Sql_SqlNullOrdering: SwiftProtobuf.Enum {
  typealias RawValue = Int
  case sqlNullsSortedHigh // = 0
  case sqlNullsSortedLow // = 1
  case sqlNullsSortedAtStart // = 2
  case sqlNullsSortedAtEnd // = 3
  case UNRECOGNIZED(Int)

  init() {
    self = .sqlNullsSortedHigh
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .sqlNullsSortedHigh
    case 1: self = .sqlNullsSortedLow
    case 2: self = .sqlNullsSortedAtStart
    case 3: self = .sqlNullsSortedAtEnd
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .sqlNullsSortedHigh: return 0
    case .sqlNullsSortedLow: return 1
    case .sqlNullsSortedAtStart: return 2
    case .sqlNullsSortedAtEnd: return 3
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_SqlNullOrdering: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_SqlNullOrdering] = [
    .sqlNullsSortedHigh,
    .sqlNullsSortedLow,
    .sqlNullsSortedAtStart,
    .sqlNullsSortedAtEnd,
  ]
}

#endif  // swift(>=4.2)

enum Arrow_Flight_Protocol_Sql_SupportedSqlGrammar: SwiftProtobuf.Enum {
  typealias RawValue = Int
  case sqlMinimumGrammar // = 0
  case sqlCoreGrammar // = 1
  case sqlExtendedGrammar // = 2
  case UNRECOGNIZED(Int)

  init() {
    self = .sqlMinimumGrammar
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .sqlMinimumGrammar
    case 1: self = .sqlCoreGrammar
    case 2: self = .sqlExtendedGrammar
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .sqlMinimumGrammar: return 0
    case .sqlCoreGrammar: return 1
    case .sqlExtendedGrammar: return 2
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_SupportedSqlGrammar: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_SupportedSqlGrammar] = [
    .sqlMinimumGrammar,
    .sqlCoreGrammar,
    .sqlExtendedGrammar,
  ]
}

#endif  // swift(>=4.2)

enum Arrow_Flight_Protocol_Sql_SupportedAnsi92SqlGrammarLevel: SwiftProtobuf.Enum {
  typealias RawValue = Int
  case ansi92EntrySql // = 0
  case ansi92IntermediateSql // = 1
  case ansi92FullSql // = 2
  case UNRECOGNIZED(Int)

  init() {
    self = .ansi92EntrySql
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .ansi92EntrySql
    case 1: self = .ansi92IntermediateSql
    case 2: self = .ansi92FullSql
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .ansi92EntrySql: return 0
    case .ansi92IntermediateSql: return 1
    case .ansi92FullSql: return 2
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_SupportedAnsi92SqlGrammarLevel: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_SupportedAnsi92SqlGrammarLevel] = [
    .ansi92EntrySql,
    .ansi92IntermediateSql,
    .ansi92FullSql,
  ]
}

#endif  // swift(>=4.2)

enum Arrow_Flight_Protocol_Sql_SqlOuterJoinsSupportLevel: SwiftProtobuf.Enum {
  typealias RawValue = Int
  case sqlJoinsUnsupported // = 0
  case sqlLimitedOuterJoins // = 1
  case sqlFullOuterJoins // = 2
  case UNRECOGNIZED(Int)

  init() {
    self = .sqlJoinsUnsupported
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .sqlJoinsUnsupported
    case 1: self = .sqlLimitedOuterJoins
    case 2: self = .sqlFullOuterJoins
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .sqlJoinsUnsupported: return 0
    case .sqlLimitedOuterJoins: return 1
    case .sqlFullOuterJoins: return 2
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_SqlOuterJoinsSupportLevel: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_SqlOuterJoinsSupportLevel] = [
    .sqlJoinsUnsupported,
    .sqlLimitedOuterJoins,
    .sqlFullOuterJoins,
  ]
}

#endif  // swift(>=4.2)

enum Arrow_Flight_Protocol_Sql_SqlSupportedGroupBy: SwiftProtobuf.Enum {
  typealias RawValue = Int
  case sqlGroupByUnrelated // = 0
  case sqlGroupByBeyondSelect // = 1
  case UNRECOGNIZED(Int)

  init() {
    self = .sqlGroupByUnrelated
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .sqlGroupByUnrelated
    case 1: self = .sqlGroupByBeyondSelect
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .sqlGroupByUnrelated: return 0
    case .sqlGroupByBeyondSelect: return 1
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_SqlSupportedGroupBy: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_SqlSupportedGroupBy] = [
    .sqlGroupByUnrelated,
    .sqlGroupByBeyondSelect,
  ]
}

#endif  // swift(>=4.2)

enum Arrow_Flight_Protocol_Sql_SqlSupportedElementActions: SwiftProtobuf.Enum {
  typealias RawValue = Int
  case sqlElementInProcedureCalls // = 0
  case sqlElementInIndexDefinitions // = 1
  case sqlElementInPrivilegeDefinitions // = 2
  case UNRECOGNIZED(Int)

  init() {
    self = .sqlElementInProcedureCalls
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .sqlElementInProcedureCalls
    case 1: self = .sqlElementInIndexDefinitions
    case 2: self = .sqlElementInPrivilegeDefinitions
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .sqlElementInProcedureCalls: return 0
    case .sqlElementInIndexDefinitions: return 1
    case .sqlElementInPrivilegeDefinitions: return 2
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_SqlSupportedElementActions: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_SqlSupportedElementActions] = [
    .sqlElementInProcedureCalls,
    .sqlElementInIndexDefinitions,
    .sqlElementInPrivilegeDefinitions,
  ]
}

#endif  // swift(>=4.2)

enum Arrow_Flight_Protocol_Sql_SqlSupportedPositionedCommands: SwiftProtobuf.Enum {
  typealias RawValue = Int
  case sqlPositionedDelete // = 0
  case sqlPositionedUpdate // = 1
  case UNRECOGNIZED(Int)

  init() {
    self = .sqlPositionedDelete
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .sqlPositionedDelete
    case 1: self = .sqlPositionedUpdate
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .sqlPositionedDelete: return 0
    case .sqlPositionedUpdate: return 1
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_SqlSupportedPositionedCommands: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_SqlSupportedPositionedCommands] = [
    .sqlPositionedDelete,
    .sqlPositionedUpdate,
  ]
}

#endif  // swift(>=4.2)

enum Arrow_Flight_Protocol_Sql_SqlSupportedSubqueries: SwiftProtobuf.Enum {
  typealias RawValue = Int
  case sqlSubqueriesInComparisons // = 0
  case sqlSubqueriesInExists // = 1
  case sqlSubqueriesInIns // = 2
  case sqlSubqueriesInQuantifieds // = 3
  case UNRECOGNIZED(Int)

  init() {
    self = .sqlSubqueriesInComparisons
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .sqlSubqueriesInComparisons
    case 1: self = .sqlSubqueriesInExists
    case 2: self = .sqlSubqueriesInIns
    case 3: self = .sqlSubqueriesInQuantifieds
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .sqlSubqueriesInComparisons: return 0
    case .sqlSubqueriesInExists: return 1
    case .sqlSubqueriesInIns: return 2
    case .sqlSubqueriesInQuantifieds: return 3
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_SqlSupportedSubqueries: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_SqlSupportedSubqueries] = [
    .sqlSubqueriesInComparisons,
    .sqlSubqueriesInExists,
    .sqlSubqueriesInIns,
    .sqlSubqueriesInQuantifieds,
  ]
}

#endif  // swift(>=4.2)

enum Arrow_Flight_Protocol_Sql_SqlSupportedUnions: SwiftProtobuf.Enum {
  typealias RawValue = Int
  case sqlUnion // = 0
  case sqlUnionAll // = 1
  case UNRECOGNIZED(Int)

  init() {
    self = .sqlUnion
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .sqlUnion
    case 1: self = .sqlUnionAll
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .sqlUnion: return 0
    case .sqlUnionAll: return 1
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_SqlSupportedUnions: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_SqlSupportedUnions] = [
    .sqlUnion,
    .sqlUnionAll,
  ]
}

#endif  // swift(>=4.2)

enum Arrow_Flight_Protocol_Sql_SqlTransactionIsolationLevel: SwiftProtobuf.Enum {
  typealias RawValue = Int
  case sqlTransactionNone // = 0
  case sqlTransactionReadUncommitted // = 1
  case sqlTransactionReadCommitted // = 2
  case sqlTransactionRepeatableRead // = 3
  case sqlTransactionSerializable // = 4
  case UNRECOGNIZED(Int)

  init() {
    self = .sqlTransactionNone
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .sqlTransactionNone
    case 1: self = .sqlTransactionReadUncommitted
    case 2: self = .sqlTransactionReadCommitted
    case 3: self = .sqlTransactionRepeatableRead
    case 4: self = .sqlTransactionSerializable
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .sqlTransactionNone: return 0
    case .sqlTransactionReadUncommitted: return 1
    case .sqlTransactionReadCommitted: return 2
    case .sqlTransactionRepeatableRead: return 3
    case .sqlTransactionSerializable: return 4
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_SqlTransactionIsolationLevel: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_SqlTransactionIsolationLevel] = [
    .sqlTransactionNone,
    .sqlTransactionReadUncommitted,
    .sqlTransactionReadCommitted,
    .sqlTransactionRepeatableRead,
    .sqlTransactionSerializable,
  ]
}

#endif  // swift(>=4.2)

enum Arrow_Flight_Protocol_Sql_SqlSupportedTransactions: SwiftProtobuf.Enum {
  typealias RawValue = Int
  case sqlTransactionUnspecified // = 0
  case sqlDataDefinitionTransactions // = 1
  case sqlDataManipulationTransactions // = 2
  case UNRECOGNIZED(Int)

  init() {
    self = .sqlTransactionUnspecified
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .sqlTransactionUnspecified
    case 1: self = .sqlDataDefinitionTransactions
    case 2: self = .sqlDataManipulationTransactions
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .sqlTransactionUnspecified: return 0
    case .sqlDataDefinitionTransactions: return 1
    case .sqlDataManipulationTransactions: return 2
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_SqlSupportedTransactions: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_SqlSupportedTransactions] = [
    .sqlTransactionUnspecified,
    .sqlDataDefinitionTransactions,
    .sqlDataManipulationTransactions,
  ]
}

#endif  // swift(>=4.2)

enum Arrow_Flight_Protocol_Sql_SqlSupportedResultSetType: SwiftProtobuf.Enum {
  typealias RawValue = Int
  case sqlResultSetTypeUnspecified // = 0
  case sqlResultSetTypeForwardOnly // = 1
  case sqlResultSetTypeScrollInsensitive // = 2
  case sqlResultSetTypeScrollSensitive // = 3
  case UNRECOGNIZED(Int)

  init() {
    self = .sqlResultSetTypeUnspecified
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .sqlResultSetTypeUnspecified
    case 1: self = .sqlResultSetTypeForwardOnly
    case 2: self = .sqlResultSetTypeScrollInsensitive
    case 3: self = .sqlResultSetTypeScrollSensitive
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .sqlResultSetTypeUnspecified: return 0
    case .sqlResultSetTypeForwardOnly: return 1
    case .sqlResultSetTypeScrollInsensitive: return 2
    case .sqlResultSetTypeScrollSensitive: return 3
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_SqlSupportedResultSetType: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_SqlSupportedResultSetType] = [
    .sqlResultSetTypeUnspecified,
    .sqlResultSetTypeForwardOnly,
    .sqlResultSetTypeScrollInsensitive,
    .sqlResultSetTypeScrollSensitive,
  ]
}

#endif  // swift(>=4.2)

enum Arrow_Flight_Protocol_Sql_SqlSupportedResultSetConcurrency: SwiftProtobuf.Enum {
  typealias RawValue = Int
  case sqlResultSetConcurrencyUnspecified // = 0
  case sqlResultSetConcurrencyReadOnly // = 1
  case sqlResultSetConcurrencyUpdatable // = 2
  case UNRECOGNIZED(Int)

  init() {
    self = .sqlResultSetConcurrencyUnspecified
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .sqlResultSetConcurrencyUnspecified
    case 1: self = .sqlResultSetConcurrencyReadOnly
    case 2: self = .sqlResultSetConcurrencyUpdatable
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .sqlResultSetConcurrencyUnspecified: return 0
    case .sqlResultSetConcurrencyReadOnly: return 1
    case .sqlResultSetConcurrencyUpdatable: return 2
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_SqlSupportedResultSetConcurrency: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_SqlSupportedResultSetConcurrency] = [
    .sqlResultSetConcurrencyUnspecified,
    .sqlResultSetConcurrencyReadOnly,
    .sqlResultSetConcurrencyUpdatable,
  ]
}

#endif  // swift(>=4.2)

enum Arrow_Flight_Protocol_Sql_SqlSupportsConvert: SwiftProtobuf.Enum {
  typealias RawValue = Int
  case sqlConvertBigint // = 0
  case sqlConvertBinary // = 1
  case sqlConvertBit // = 2
  case sqlConvertChar // = 3
  case sqlConvertDate // = 4
  case sqlConvertDecimal // = 5
  case sqlConvertFloat // = 6
  case sqlConvertInteger // = 7
  case sqlConvertIntervalDayTime // = 8
  case sqlConvertIntervalYearMonth // = 9
  case sqlConvertLongvarbinary // = 10
  case sqlConvertLongvarchar // = 11
  case sqlConvertNumeric // = 12
  case sqlConvertReal // = 13
  case sqlConvertSmallint // = 14
  case sqlConvertTime // = 15
  case sqlConvertTimestamp // = 16
  case sqlConvertTinyint // = 17
  case sqlConvertVarbinary // = 18
  case sqlConvertVarchar // = 19
  case UNRECOGNIZED(Int)

  init() {
    self = .sqlConvertBigint
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .sqlConvertBigint
    case 1: self = .sqlConvertBinary
    case 2: self = .sqlConvertBit
    case 3: self = .sqlConvertChar
    case 4: self = .sqlConvertDate
    case 5: self = .sqlConvertDecimal
    case 6: self = .sqlConvertFloat
    case 7: self = .sqlConvertInteger
    case 8: self = .sqlConvertIntervalDayTime
    case 9: self = .sqlConvertIntervalYearMonth
    case 10: self = .sqlConvertLongvarbinary
    case 11: self = .sqlConvertLongvarchar
    case 12: self = .sqlConvertNumeric
    case 13: self = .sqlConvertReal
    case 14: self = .sqlConvertSmallint
    case 15: self = .sqlConvertTime
    case 16: self = .sqlConvertTimestamp
    case 17: self = .sqlConvertTinyint
    case 18: self = .sqlConvertVarbinary
    case 19: self = .sqlConvertVarchar
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .sqlConvertBigint: return 0
    case .sqlConvertBinary: return 1
    case .sqlConvertBit: return 2
    case .sqlConvertChar: return 3
    case .sqlConvertDate: return 4
    case .sqlConvertDecimal: return 5
    case .sqlConvertFloat: return 6
    case .sqlConvertInteger: return 7
    case .sqlConvertIntervalDayTime: return 8
    case .sqlConvertIntervalYearMonth: return 9
    case .sqlConvertLongvarbinary: return 10
    case .sqlConvertLongvarchar: return 11
    case .sqlConvertNumeric: return 12
    case .sqlConvertReal: return 13
    case .sqlConvertSmallint: return 14
    case .sqlConvertTime: return 15
    case .sqlConvertTimestamp: return 16
    case .sqlConvertTinyint: return 17
    case .sqlConvertVarbinary: return 18
    case .sqlConvertVarchar: return 19
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_SqlSupportsConvert: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_SqlSupportsConvert] = [
    .sqlConvertBigint,
    .sqlConvertBinary,
    .sqlConvertBit,
    .sqlConvertChar,
    .sqlConvertDate,
    .sqlConvertDecimal,
    .sqlConvertFloat,
    .sqlConvertInteger,
    .sqlConvertIntervalDayTime,
    .sqlConvertIntervalYearMonth,
    .sqlConvertLongvarbinary,
    .sqlConvertLongvarchar,
    .sqlConvertNumeric,
    .sqlConvertReal,
    .sqlConvertSmallint,
    .sqlConvertTime,
    .sqlConvertTimestamp,
    .sqlConvertTinyint,
    .sqlConvertVarbinary,
    .sqlConvertVarchar,
  ]
}

#endif  // swift(>=4.2)

///*
/// The JDBC/ODBC-defined type of any object.
/// All the values here are the same as in the JDBC and ODBC specs.
enum Arrow_Flight_Protocol_Sql_XdbcDataType: SwiftProtobuf.Enum {
  typealias RawValue = Int
  case xdbcUnknownType // = 0
  case xdbcChar // = 1
  case xdbcNumeric // = 2
  case xdbcDecimal // = 3
  case xdbcInteger // = 4
  case xdbcSmallint // = 5
  case xdbcFloat // = 6
  case xdbcReal // = 7
  case xdbcDouble // = 8
  case xdbcDatetime // = 9
  case xdbcInterval // = 10
  case xdbcVarchar // = 12
  case xdbcDate // = 91
  case xdbcTime // = 92
  case xdbcTimestamp // = 93
  case xdbcLongvarchar // = -1
  case xdbcBinary // = -2
  case xdbcVarbinary // = -3
  case xdbcLongvarbinary // = -4
  case xdbcBigint // = -5
  case xdbcTinyint // = -6
  case xdbcBit // = -7
  case xdbcWchar // = -8
  case xdbcWvarchar // = -9
  case UNRECOGNIZED(Int)

  init() {
    self = .xdbcUnknownType
  }

  init?(rawValue: Int) {
    switch rawValue {
    case -9: self = .xdbcWvarchar
    case -8: self = .xdbcWchar
    case -7: self = .xdbcBit
    case -6: self = .xdbcTinyint
    case -5: self = .xdbcBigint
    case -4: self = .xdbcLongvarbinary
    case -3: self = .xdbcVarbinary
    case -2: self = .xdbcBinary
    case -1: self = .xdbcLongvarchar
    case 0: self = .xdbcUnknownType
    case 1: self = .xdbcChar
    case 2: self = .xdbcNumeric
    case 3: self = .xdbcDecimal
    case 4: self = .xdbcInteger
    case 5: self = .xdbcSmallint
    case 6: self = .xdbcFloat
    case 7: self = .xdbcReal
    case 8: self = .xdbcDouble
    case 9: self = .xdbcDatetime
    case 10: self = .xdbcInterval
    case 12: self = .xdbcVarchar
    case 91: self = .xdbcDate
    case 92: self = .xdbcTime
    case 93: self = .xdbcTimestamp
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .xdbcWvarchar: return -9
    case .xdbcWchar: return -8
    case .xdbcBit: return -7
    case .xdbcTinyint: return -6
    case .xdbcBigint: return -5
    case .xdbcLongvarbinary: return -4
    case .xdbcVarbinary: return -3
    case .xdbcBinary: return -2
    case .xdbcLongvarchar: return -1
    case .xdbcUnknownType: return 0
    case .xdbcChar: return 1
    case .xdbcNumeric: return 2
    case .xdbcDecimal: return 3
    case .xdbcInteger: return 4
    case .xdbcSmallint: return 5
    case .xdbcFloat: return 6
    case .xdbcReal: return 7
    case .xdbcDouble: return 8
    case .xdbcDatetime: return 9
    case .xdbcInterval: return 10
    case .xdbcVarchar: return 12
    case .xdbcDate: return 91
    case .xdbcTime: return 92
    case .xdbcTimestamp: return 93
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_XdbcDataType: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_XdbcDataType] = [
    .xdbcUnknownType,
    .xdbcChar,
    .xdbcNumeric,
    .xdbcDecimal,
    .xdbcInteger,
    .xdbcSmallint,
    .xdbcFloat,
    .xdbcReal,
    .xdbcDouble,
    .xdbcDatetime,
    .xdbcInterval,
    .xdbcVarchar,
    .xdbcDate,
    .xdbcTime,
    .xdbcTimestamp,
    .xdbcLongvarchar,
    .xdbcBinary,
    .xdbcVarbinary,
    .xdbcLongvarbinary,
    .xdbcBigint,
    .xdbcTinyint,
    .xdbcBit,
    .xdbcWchar,
    .xdbcWvarchar,
  ]
}

#endif  // swift(>=4.2)

///*
/// Detailed subtype information for XDBC_TYPE_DATETIME and XDBC_TYPE_INTERVAL.
enum Arrow_Flight_Protocol_Sql_XdbcDatetimeSubcode: SwiftProtobuf.Enum {
  typealias RawValue = Int
  case xdbcSubcodeUnknown // = 0
  case xdbcSubcodeYear // = 1
  static let xdbcSubcodeDate = xdbcSubcodeYear
  case xdbcSubcodeTime // = 2
  static let xdbcSubcodeMonth = xdbcSubcodeTime
  case xdbcSubcodeTimestamp // = 3
  static let xdbcSubcodeDay = xdbcSubcodeTimestamp
  case xdbcSubcodeTimeWithTimezone // = 4
  static let xdbcSubcodeHour = xdbcSubcodeTimeWithTimezone
  case xdbcSubcodeTimestampWithTimezone // = 5
  static let xdbcSubcodeMinute = xdbcSubcodeTimestampWithTimezone
  case xdbcSubcodeSecond // = 6
  case xdbcSubcodeYearToMonth // = 7
  case xdbcSubcodeDayToHour // = 8
  case xdbcSubcodeDayToMinute // = 9
  case xdbcSubcodeDayToSecond // = 10
  case xdbcSubcodeHourToMinute // = 11
  case xdbcSubcodeHourToSecond // = 12
  case xdbcSubcodeMinuteToSecond // = 13
  case xdbcSubcodeIntervalYear // = 101
  case xdbcSubcodeIntervalMonth // = 102
  case xdbcSubcodeIntervalDay // = 103
  case xdbcSubcodeIntervalHour // = 104
  case xdbcSubcodeIntervalMinute // = 105
  case xdbcSubcodeIntervalSecond // = 106
  case xdbcSubcodeIntervalYearToMonth // = 107
  case xdbcSubcodeIntervalDayToHour // = 108
  case xdbcSubcodeIntervalDayToMinute // = 109
  case xdbcSubcodeIntervalDayToSecond // = 110
  case xdbcSubcodeIntervalHourToMinute // = 111
  case xdbcSubcodeIntervalHourToSecond // = 112
  case xdbcSubcodeIntervalMinuteToSecond // = 113
  case UNRECOGNIZED(Int)

  init() {
    self = .xdbcSubcodeUnknown
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .xdbcSubcodeUnknown
    case 1: self = .xdbcSubcodeYear
    case 2: self = .xdbcSubcodeTime
    case 3: self = .xdbcSubcodeTimestamp
    case 4: self = .xdbcSubcodeTimeWithTimezone
    case 5: self = .xdbcSubcodeTimestampWithTimezone
    case 6: self = .xdbcSubcodeSecond
    case 7: self = .xdbcSubcodeYearToMonth
    case 8: self = .xdbcSubcodeDayToHour
    case 9: self = .xdbcSubcodeDayToMinute
    case 10: self = .xdbcSubcodeDayToSecond
    case 11: self = .xdbcSubcodeHourToMinute
    case 12: self = .xdbcSubcodeHourToSecond
    case 13: self = .xdbcSubcodeMinuteToSecond
    case 101: self = .xdbcSubcodeIntervalYear
    case 102: self = .xdbcSubcodeIntervalMonth
    case 103: self = .xdbcSubcodeIntervalDay
    case 104: self = .xdbcSubcodeIntervalHour
    case 105: self = .xdbcSubcodeIntervalMinute
    case 106: self = .xdbcSubcodeIntervalSecond
    case 107: self = .xdbcSubcodeIntervalYearToMonth
    case 108: self = .xdbcSubcodeIntervalDayToHour
    case 109: self = .xdbcSubcodeIntervalDayToMinute
    case 110: self = .xdbcSubcodeIntervalDayToSecond
    case 111: self = .xdbcSubcodeIntervalHourToMinute
    case 112: self = .xdbcSubcodeIntervalHourToSecond
    case 113: self = .xdbcSubcodeIntervalMinuteToSecond
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .xdbcSubcodeUnknown: return 0
    case .xdbcSubcodeYear: return 1
    case .xdbcSubcodeTime: return 2
    case .xdbcSubcodeTimestamp: return 3
    case .xdbcSubcodeTimeWithTimezone: return 4
    case .xdbcSubcodeTimestampWithTimezone: return 5
    case .xdbcSubcodeSecond: return 6
    case .xdbcSubcodeYearToMonth: return 7
    case .xdbcSubcodeDayToHour: return 8
    case .xdbcSubcodeDayToMinute: return 9
    case .xdbcSubcodeDayToSecond: return 10
    case .xdbcSubcodeHourToMinute: return 11
    case .xdbcSubcodeHourToSecond: return 12
    case .xdbcSubcodeMinuteToSecond: return 13
    case .xdbcSubcodeIntervalYear: return 101
    case .xdbcSubcodeIntervalMonth: return 102
    case .xdbcSubcodeIntervalDay: return 103
    case .xdbcSubcodeIntervalHour: return 104
    case .xdbcSubcodeIntervalMinute: return 105
    case .xdbcSubcodeIntervalSecond: return 106
    case .xdbcSubcodeIntervalYearToMonth: return 107
    case .xdbcSubcodeIntervalDayToHour: return 108
    case .xdbcSubcodeIntervalDayToMinute: return 109
    case .xdbcSubcodeIntervalDayToSecond: return 110
    case .xdbcSubcodeIntervalHourToMinute: return 111
    case .xdbcSubcodeIntervalHourToSecond: return 112
    case .xdbcSubcodeIntervalMinuteToSecond: return 113
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_XdbcDatetimeSubcode: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_XdbcDatetimeSubcode] = [
    .xdbcSubcodeUnknown,
    .xdbcSubcodeYear,
    .xdbcSubcodeTime,
    .xdbcSubcodeTimestamp,
    .xdbcSubcodeTimeWithTimezone,
    .xdbcSubcodeTimestampWithTimezone,
    .xdbcSubcodeSecond,
    .xdbcSubcodeYearToMonth,
    .xdbcSubcodeDayToHour,
    .xdbcSubcodeDayToMinute,
    .xdbcSubcodeDayToSecond,
    .xdbcSubcodeHourToMinute,
    .xdbcSubcodeHourToSecond,
    .xdbcSubcodeMinuteToSecond,
    .xdbcSubcodeIntervalYear,
    .xdbcSubcodeIntervalMonth,
    .xdbcSubcodeIntervalDay,
    .xdbcSubcodeIntervalHour,
    .xdbcSubcodeIntervalMinute,
    .xdbcSubcodeIntervalSecond,
    .xdbcSubcodeIntervalYearToMonth,
    .xdbcSubcodeIntervalDayToHour,
    .xdbcSubcodeIntervalDayToMinute,
    .xdbcSubcodeIntervalDayToSecond,
    .xdbcSubcodeIntervalHourToMinute,
    .xdbcSubcodeIntervalHourToSecond,
    .xdbcSubcodeIntervalMinuteToSecond,
  ]
}

#endif  // swift(>=4.2)

enum Arrow_Flight_Protocol_Sql_Nullable: SwiftProtobuf.Enum {
  typealias RawValue = Int

  ///*
  /// Indicates that the fields does not allow the use of null values.
  case nullabilityNoNulls // = 0

  ///*
  /// Indicates that the fields allow the use of null values.
  case nullabilityNullable // = 1

  ///*
  /// Indicates that nullability of the fields cannot be determined.
  case nullabilityUnknown // = 2
  case UNRECOGNIZED(Int)

  init() {
    self = .nullabilityNoNulls
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .nullabilityNoNulls
    case 1: self = .nullabilityNullable
    case 2: self = .nullabilityUnknown
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .nullabilityNoNulls: return 0
    case .nullabilityNullable: return 1
    case .nullabilityUnknown: return 2
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_Nullable: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_Nullable] = [
    .nullabilityNoNulls,
    .nullabilityNullable,
    .nullabilityUnknown,
  ]
}

#endif  // swift(>=4.2)

enum Arrow_Flight_Protocol_Sql_Searchable: SwiftProtobuf.Enum {
  typealias RawValue = Int

  ///*
  /// Indicates that column cannot be used in a WHERE clause.
  case none // = 0

  ///*
  /// Indicates that the column can be used in a WHERE clause if it is using a
  /// LIKE operator.
  case char // = 1

  ///*
  /// Indicates that the column can be used In a WHERE clause with any
  /// operator other than LIKE.
  ///
  /// - Allowed operators: comparison, quantified comparison, BETWEEN,
  ///                      DISTINCT, IN, MATCH, and UNIQUE.
  case basic // = 2

  ///*
  /// Indicates that the column can be used in a WHERE clause using any operator.
  case full // = 3
  case UNRECOGNIZED(Int)

  init() {
    self = .none
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .none
    case 1: self = .char
    case 2: self = .basic
    case 3: self = .full
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .none: return 0
    case .char: return 1
    case .basic: return 2
    case .full: return 3
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_Searchable: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_Searchable] = [
    .none,
    .char,
    .basic,
    .full,
  ]
}

#endif  // swift(>=4.2)

enum Arrow_Flight_Protocol_Sql_UpdateDeleteRules: SwiftProtobuf.Enum {
  typealias RawValue = Int
  case cascade // = 0
  case restrict // = 1
  case setNull // = 2
  case noAction // = 3
  case setDefault // = 4
  case UNRECOGNIZED(Int)

  init() {
    self = .cascade
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .cascade
    case 1: self = .restrict
    case 2: self = .setNull
    case 3: self = .noAction
    case 4: self = .setDefault
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .cascade: return 0
    case .restrict: return 1
    case .setNull: return 2
    case .noAction: return 3
    case .setDefault: return 4
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_UpdateDeleteRules: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_UpdateDeleteRules] = [
    .cascade,
    .restrict,
    .setNull,
    .noAction,
    .setDefault,
  ]
}

#endif  // swift(>=4.2)

///
/// Represents a metadata request. Used in the command member of FlightDescriptor
/// for the following RPC calls:
///  - GetSchema: return the Arrow schema of the query.
///  - GetFlightInfo: execute the metadata request.
///
/// The returned Arrow schema will be:
/// <
///  info_name: uint32 not null,
///  value: dense_union<
///              string_value: utf8,
///              bool_value: bool,
///              bigint_value: int64,
///              int32_bitmask: int32,
///              string_list: list<string_data: utf8>
///              int32_to_int32_list_map: map<key: int32, value: list<$data$: int32>>
/// >
/// where there is one row per requested piece of metadata information.
struct Arrow_Flight_Protocol_Sql_CommandGetSqlInfo {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///
  /// Values are modelled after ODBC's SQLGetInfo() function. This information is intended to provide
  /// Flight SQL clients with basic, SQL syntax and SQL functions related information.
  /// More information types can be added in future releases.
  /// E.g. more SQL syntax support types, scalar functions support, type conversion support etc.
  ///
  /// Note that the set of metadata may expand.
  ///
  /// Initially, Flight SQL will support the following information types:
  /// - Server Information - Range [0-500)
  /// - Syntax Information - Range [500-1000)
  /// Range [0-10,000) is reserved for defaults (see SqlInfo enum for default options).
  /// Custom options should start at 10,000.
  ///
  /// If omitted, then all metadata will be retrieved.
  /// Flight SQL Servers may choose to include additional metadata above and beyond the specified set, however they must
  /// at least return the specified set. IDs ranging from 0 to 10,000 (exclusive) are reserved for future use.
  /// If additional metadata is included, the metadata IDs should start from 10,000.
  var info: [UInt32] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///
/// Represents a request to retrieve information about data type supported on a Flight SQL enabled backend.
/// Used in the command member of FlightDescriptor for the following RPC calls:
///  - GetSchema: return the schema of the query.
///  - GetFlightInfo: execute the catalog metadata request.
///
/// The returned schema will be:
/// <
///   type_name: utf8 not null (The name of the data type, for example: VARCHAR, INTEGER, etc),
///   data_type: int32 not null (The SQL data type),
///   column_size: int32 (The maximum size supported by that column.
///                       In case of exact numeric types, this represents the maximum precision.
///                       In case of string types, this represents the character length.
///                       In case of datetime data types, this represents the length in characters of the string representation.
///                       NULL is returned for data types where column size is not applicable.),
///   literal_prefix: utf8 (Character or characters used to prefix a literal, NULL is returned for
///                         data types where a literal prefix is not applicable.),
///   literal_suffix: utf8 (Character or characters used to terminate a literal,
///                         NULL is returned for data types where a literal suffix is not applicable.),
///   create_params: list<utf8 not null>
///                        (A list of keywords corresponding to which parameters can be used when creating
///                         a column for that specific type.
///                         NULL is returned if there are no parameters for the data type definition.),
///   nullable: int32 not null (Shows if the data type accepts a NULL value. The possible values can be seen in the
///                             Nullable enum.),
///   case_sensitive: bool not null (Shows if a character data type is case-sensitive in collations and comparisons),
///   searchable: int32 not null (Shows how the data type is used in a WHERE clause. The possible values can be seen in the
///                               Searchable enum.),
///   unsigned_attribute: bool (Shows if the data type is unsigned. NULL is returned if the attribute is
///                             not applicable to the data type or the data type is not numeric.),
///   fixed_prec_scale: bool not null (Shows if the data type has predefined fixed precision and scale.),
///   auto_increment: bool (Shows if the data type is auto incremental. NULL is returned if the attribute
///                         is not applicable to the data type or the data type is not numeric.),
///   local_type_name: utf8 (Localized version of the data source-dependent name of the data type. NULL
///                          is returned if a localized name is not supported by the data source),
///   minimum_scale: int32 (The minimum scale of the data type on the data source.
///                         If a data type has a fixed scale, the MINIMUM_SCALE and MAXIMUM_SCALE
///                         columns both contain this value. NULL is returned if scale is not applicable.),
///   maximum_scale: int32 (The maximum scale of the data type on the data source.
///                         NULL is returned if scale is not applicable.),
///   sql_data_type: int32 not null (The value of the SQL DATA TYPE which has the same values
///                                  as data_type value. Except for interval and datetime, which
///                                  uses generic values. More info about those types can be
///                                  obtained through datetime_subcode. The possible values can be seen
///                                  in the XdbcDataType enum.),
///   datetime_subcode: int32 (Only used when the SQL DATA TYPE is interval or datetime. It contains
///                            its sub types. For type different from interval and datetime, this value
///                            is NULL. The possible values can be seen in the XdbcDatetimeSubcode enum.),
///   num_prec_radix: int32 (If the data type is an approximate numeric type, this column contains
///                          the value 2 to indicate that COLUMN_SIZE specifies a number of bits. For
///                          exact numeric types, this column contains the value 10 to indicate that
///                          column size specifies a number of decimal digits. Otherwise, this column is NULL.),
///   interval_precision: int32 (If the data type is an interval data type, then this column contains the value
///                              of the interval leading precision. Otherwise, this column is NULL. This fields
///                              is only relevant to be used by ODBC).
/// >
/// The returned data should be ordered by data_type and then by type_name.
struct Arrow_Flight_Protocol_Sql_CommandGetXdbcTypeInfo {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///
  /// Specifies the data type to search for the info.
  var dataType: Int32 {
    get {return _dataType ?? 0}
    set {_dataType = newValue}
  }
  /// Returns true if `dataType` has been explicitly set.
  var hasDataType: Bool {return self._dataType != nil}
  /// Clears the value of `dataType`. Subsequent reads from it will return its default value.
  mutating func clearDataType() {self._dataType = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _dataType: Int32? = nil
}

///
/// Represents a request to retrieve the list of catalogs on a Flight SQL enabled backend.
/// The definition of a catalog depends on vendor/implementation. It is usually the database itself
/// Used in the command member of FlightDescriptor for the following RPC calls:
///  - GetSchema: return the Arrow schema of the query.
///  - GetFlightInfo: execute the catalog metadata request.
///
/// The returned Arrow schema will be:
/// <
///  catalog_name: utf8 not null
/// >
/// The returned data should be ordered by catalog_name.
struct Arrow_Flight_Protocol_Sql_CommandGetCatalogs {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///
/// Represents a request to retrieve the list of database schemas on a Flight SQL enabled backend.
/// The definition of a database schema depends on vendor/implementation. It is usually a collection of tables.
/// Used in the command member of FlightDescriptor for the following RPC calls:
///  - GetSchema: return the Arrow schema of the query.
///  - GetFlightInfo: execute the catalog metadata request.
///
/// The returned Arrow schema will be:
/// <
///  catalog_name: utf8,
///  db_schema_name: utf8 not null
/// >
/// The returned data should be ordered by catalog_name, then db_schema_name.
struct Arrow_Flight_Protocol_Sql_CommandGetDbSchemas {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///
  /// Specifies the Catalog to search for the tables.
  /// An empty string retrieves those without a catalog.
  /// If omitted the catalog name should not be used to narrow the search.
  var catalog: String {
    get {return _catalog ?? String()}
    set {_catalog = newValue}
  }
  /// Returns true if `catalog` has been explicitly set.
  var hasCatalog: Bool {return self._catalog != nil}
  /// Clears the value of `catalog`. Subsequent reads from it will return its default value.
  mutating func clearCatalog() {self._catalog = nil}

  ///
  /// Specifies a filter pattern for schemas to search for.
  /// When no db_schema_filter_pattern is provided, the pattern will not be used to narrow the search.
  /// In the pattern string, two special characters can be used to denote matching rules:
  ///    - "%" means to match any substring with 0 or more characters.
  ///    - "_" means to match any one character.
  var dbSchemaFilterPattern: String {
    get {return _dbSchemaFilterPattern ?? String()}
    set {_dbSchemaFilterPattern = newValue}
  }
  /// Returns true if `dbSchemaFilterPattern` has been explicitly set.
  var hasDbSchemaFilterPattern: Bool {return self._dbSchemaFilterPattern != nil}
  /// Clears the value of `dbSchemaFilterPattern`. Subsequent reads from it will return its default value.
  mutating func clearDbSchemaFilterPattern() {self._dbSchemaFilterPattern = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _catalog: String? = nil
  fileprivate var _dbSchemaFilterPattern: String? = nil
}

///
/// Represents a request to retrieve the list of tables, and optionally their schemas, on a Flight SQL enabled backend.
/// Used in the command member of FlightDescriptor for the following RPC calls:
///  - GetSchema: return the Arrow schema of the query.
///  - GetFlightInfo: execute the catalog metadata request.
///
/// The returned Arrow schema will be:
/// <
///  catalog_name: utf8,
///  db_schema_name: utf8,
///  table_name: utf8 not null,
///  table_type: utf8 not null,
///  [optional] table_schema: bytes not null (schema of the table as described in Schema.fbs::Schema,
///                                           it is serialized as an IPC message.)
/// >
/// Fields on table_schema may contain the following metadata:
///  - ARROW:FLIGHT:SQL:CATALOG_NAME      - Table's catalog name
///  - ARROW:FLIGHT:SQL:DB_SCHEMA_NAME    - Database schema name
///  - ARROW:FLIGHT:SQL:TABLE_NAME        - Table name
///  - ARROW:FLIGHT:SQL:TYPE_NAME         - The data source-specific name for the data type of the column.
///  - ARROW:FLIGHT:SQL:PRECISION         - Column precision/size
///  - ARROW:FLIGHT:SQL:SCALE             - Column scale/decimal digits if applicable
///  - ARROW:FLIGHT:SQL:IS_AUTO_INCREMENT - "1" indicates if the column is auto incremented, "0" otherwise.
///  - ARROW:FLIGHT:SQL:IS_CASE_SENSITIVE - "1" indicates if the column is case-sensitive, "0" otherwise.
///  - ARROW:FLIGHT:SQL:IS_READ_ONLY      - "1" indicates if the column is read only, "0" otherwise.
///  - ARROW:FLIGHT:SQL:IS_SEARCHABLE     - "1" indicates if the column is searchable via WHERE clause, "0" otherwise.
/// The returned data should be ordered by catalog_name, db_schema_name, table_name, then table_type, followed by table_schema if requested.
struct Arrow_Flight_Protocol_Sql_CommandGetTables {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///
  /// Specifies the Catalog to search for the tables.
  /// An empty string retrieves those without a catalog.
  /// If omitted the catalog name should not be used to narrow the search.
  var catalog: String {
    get {return _catalog ?? String()}
    set {_catalog = newValue}
  }
  /// Returns true if `catalog` has been explicitly set.
  var hasCatalog: Bool {return self._catalog != nil}
  /// Clears the value of `catalog`. Subsequent reads from it will return its default value.
  mutating func clearCatalog() {self._catalog = nil}

  ///
  /// Specifies a filter pattern for schemas to search for.
  /// When no db_schema_filter_pattern is provided, all schemas matching other filters are searched.
  /// In the pattern string, two special characters can be used to denote matching rules:
  ///    - "%" means to match any substring with 0 or more characters.
  ///    - "_" means to match any one character.
  var dbSchemaFilterPattern: String {
    get {return _dbSchemaFilterPattern ?? String()}
    set {_dbSchemaFilterPattern = newValue}
  }
  /// Returns true if `dbSchemaFilterPattern` has been explicitly set.
  var hasDbSchemaFilterPattern: Bool {return self._dbSchemaFilterPattern != nil}
  /// Clears the value of `dbSchemaFilterPattern`. Subsequent reads from it will return its default value.
  mutating func clearDbSchemaFilterPattern() {self._dbSchemaFilterPattern = nil}

  ///
  /// Specifies a filter pattern for tables to search for.
  /// When no table_name_filter_pattern is provided, all tables matching other filters are searched.
  /// In the pattern string, two special characters can be used to denote matching rules:
  ///    - "%" means to match any substring with 0 or more characters.
  ///    - "_" means to match any one character.
  var tableNameFilterPattern: String {
    get {return _tableNameFilterPattern ?? String()}
    set {_tableNameFilterPattern = newValue}
  }
  /// Returns true if `tableNameFilterPattern` has been explicitly set.
  var hasTableNameFilterPattern: Bool {return self._tableNameFilterPattern != nil}
  /// Clears the value of `tableNameFilterPattern`. Subsequent reads from it will return its default value.
  mutating func clearTableNameFilterPattern() {self._tableNameFilterPattern = nil}

  ///
  /// Specifies a filter of table types which must match.
  /// The table types depend on vendor/implementation. It is usually used to separate tables from views or system tables.
  /// TABLE, VIEW, and SYSTEM TABLE are commonly supported.
  var tableTypes: [String] = []

  /// Specifies if the Arrow schema should be returned for found tables.
  var includeSchema: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _catalog: String? = nil
  fileprivate var _dbSchemaFilterPattern: String? = nil
  fileprivate var _tableNameFilterPattern: String? = nil
}

///
/// Represents a request to retrieve the list of table types on a Flight SQL enabled backend.
/// The table types depend on vendor/implementation. It is usually used to separate tables from views or system tables.
/// TABLE, VIEW, and SYSTEM TABLE are commonly supported.
/// Used in the command member of FlightDescriptor for the following RPC calls:
///  - GetSchema: return the Arrow schema of the query.
///  - GetFlightInfo: execute the catalog metadata request.
///
/// The returned Arrow schema will be:
/// <
///  table_type: utf8 not null
/// >
/// The returned data should be ordered by table_type.
struct Arrow_Flight_Protocol_Sql_CommandGetTableTypes {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///
/// Represents a request to retrieve the primary keys of a table on a Flight SQL enabled backend.
/// Used in the command member of FlightDescriptor for the following RPC calls:
///  - GetSchema: return the Arrow schema of the query.
///  - GetFlightInfo: execute the catalog metadata request.
///
/// The returned Arrow schema will be:
/// <
///  catalog_name: utf8,
///  db_schema_name: utf8,
///  table_name: utf8 not null,
///  column_name: utf8 not null,
///  key_name: utf8,
///  key_sequence: int32 not null
/// >
/// The returned data should be ordered by catalog_name, db_schema_name, table_name, key_name, then key_sequence.
struct Arrow_Flight_Protocol_Sql_CommandGetPrimaryKeys {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///
  /// Specifies the catalog to search for the table.
  /// An empty string retrieves those without a catalog.
  /// If omitted the catalog name should not be used to narrow the search.
  var catalog: String {
    get {return _catalog ?? String()}
    set {_catalog = newValue}
  }
  /// Returns true if `catalog` has been explicitly set.
  var hasCatalog: Bool {return self._catalog != nil}
  /// Clears the value of `catalog`. Subsequent reads from it will return its default value.
  mutating func clearCatalog() {self._catalog = nil}

  ///
  /// Specifies the schema to search for the table.
  /// An empty string retrieves those without a schema.
  /// If omitted the schema name should not be used to narrow the search.
  var dbSchema: String {
    get {return _dbSchema ?? String()}
    set {_dbSchema = newValue}
  }
  /// Returns true if `dbSchema` has been explicitly set.
  var hasDbSchema: Bool {return self._dbSchema != nil}
  /// Clears the value of `dbSchema`. Subsequent reads from it will return its default value.
  mutating func clearDbSchema() {self._dbSchema = nil}

  /// Specifies the table to get the primary keys for.
  var table: String = String()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _catalog: String? = nil
  fileprivate var _dbSchema: String? = nil
}

///
/// Represents a request to retrieve a description of the foreign key columns that reference the given table's
/// primary key columns (the foreign keys exported by a table) of a table on a Flight SQL enabled backend.
/// Used in the command member of FlightDescriptor for the following RPC calls:
///  - GetSchema: return the Arrow schema of the query.
///  - GetFlightInfo: execute the catalog metadata request.
///
/// The returned Arrow schema will be:
/// <
///  pk_catalog_name: utf8,
///  pk_db_schema_name: utf8,
///  pk_table_name: utf8 not null,
///  pk_column_name: utf8 not null,
///  fk_catalog_name: utf8,
///  fk_db_schema_name: utf8,
///  fk_table_name: utf8 not null,
///  fk_column_name: utf8 not null,
///  key_sequence: int32 not null,
///  fk_key_name: utf8,
///  pk_key_name: utf8,
///  update_rule: uint8 not null,
///  delete_rule: uint8 not null
/// >
/// The returned data should be ordered by fk_catalog_name, fk_db_schema_name, fk_table_name, fk_key_name, then key_sequence.
/// update_rule and delete_rule returns a byte that is equivalent to actions declared on UpdateDeleteRules enum.
struct Arrow_Flight_Protocol_Sql_CommandGetExportedKeys {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///
  /// Specifies the catalog to search for the foreign key table.
  /// An empty string retrieves those without a catalog.
  /// If omitted the catalog name should not be used to narrow the search.
  var catalog: String {
    get {return _catalog ?? String()}
    set {_catalog = newValue}
  }
  /// Returns true if `catalog` has been explicitly set.
  var hasCatalog: Bool {return self._catalog != nil}
  /// Clears the value of `catalog`. Subsequent reads from it will return its default value.
  mutating func clearCatalog() {self._catalog = nil}

  ///
  /// Specifies the schema to search for the foreign key table.
  /// An empty string retrieves those without a schema.
  /// If omitted the schema name should not be used to narrow the search.
  var dbSchema: String {
    get {return _dbSchema ?? String()}
    set {_dbSchema = newValue}
  }
  /// Returns true if `dbSchema` has been explicitly set.
  var hasDbSchema: Bool {return self._dbSchema != nil}
  /// Clears the value of `dbSchema`. Subsequent reads from it will return its default value.
  mutating func clearDbSchema() {self._dbSchema = nil}

  /// Specifies the foreign key table to get the foreign keys for.
  var table: String = String()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _catalog: String? = nil
  fileprivate var _dbSchema: String? = nil
}

///
/// Represents a request to retrieve the foreign keys of a table on a Flight SQL enabled backend.
/// Used in the command member of FlightDescriptor for the following RPC calls:
///  - GetSchema: return the Arrow schema of the query.
///  - GetFlightInfo: execute the catalog metadata request.
///
/// The returned Arrow schema will be:
/// <
///  pk_catalog_name: utf8,
///  pk_db_schema_name: utf8,
///  pk_table_name: utf8 not null,
///  pk_column_name: utf8 not null,
///  fk_catalog_name: utf8,
///  fk_db_schema_name: utf8,
///  fk_table_name: utf8 not null,
///  fk_column_name: utf8 not null,
///  key_sequence: int32 not null,
///  fk_key_name: utf8,
///  pk_key_name: utf8,
///  update_rule: uint8 not null,
///  delete_rule: uint8 not null
/// >
/// The returned data should be ordered by pk_catalog_name, pk_db_schema_name, pk_table_name, pk_key_name, then key_sequence.
/// update_rule and delete_rule returns a byte that is equivalent to actions:
///    - 0 = CASCADE
///    - 1 = RESTRICT
///    - 2 = SET NULL
///    - 3 = NO ACTION
///    - 4 = SET DEFAULT
struct Arrow_Flight_Protocol_Sql_CommandGetImportedKeys {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///
  /// Specifies the catalog to search for the primary key table.
  /// An empty string retrieves those without a catalog.
  /// If omitted the catalog name should not be used to narrow the search.
  var catalog: String {
    get {return _catalog ?? String()}
    set {_catalog = newValue}
  }
  /// Returns true if `catalog` has been explicitly set.
  var hasCatalog: Bool {return self._catalog != nil}
  /// Clears the value of `catalog`. Subsequent reads from it will return its default value.
  mutating func clearCatalog() {self._catalog = nil}

  ///
  /// Specifies the schema to search for the primary key table.
  /// An empty string retrieves those without a schema.
  /// If omitted the schema name should not be used to narrow the search.
  var dbSchema: String {
    get {return _dbSchema ?? String()}
    set {_dbSchema = newValue}
  }
  /// Returns true if `dbSchema` has been explicitly set.
  var hasDbSchema: Bool {return self._dbSchema != nil}
  /// Clears the value of `dbSchema`. Subsequent reads from it will return its default value.
  mutating func clearDbSchema() {self._dbSchema = nil}

  /// Specifies the primary key table to get the foreign keys for.
  var table: String = String()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _catalog: String? = nil
  fileprivate var _dbSchema: String? = nil
}

///
/// Represents a request to retrieve a description of the foreign key columns in the given foreign key table that
/// reference the primary key or the columns representing a unique constraint of the parent table (could be the same
/// or a different table) on a Flight SQL enabled backend.
/// Used in the command member of FlightDescriptor for the following RPC calls:
///  - GetSchema: return the Arrow schema of the query.
///  - GetFlightInfo: execute the catalog metadata request.
///
/// The returned Arrow schema will be:
/// <
///  pk_catalog_name: utf8,
///  pk_db_schema_name: utf8,
///  pk_table_name: utf8 not null,
///  pk_column_name: utf8 not null,
///  fk_catalog_name: utf8,
///  fk_db_schema_name: utf8,
///  fk_table_name: utf8 not null,
///  fk_column_name: utf8 not null,
///  key_sequence: int32 not null,
///  fk_key_name: utf8,
///  pk_key_name: utf8,
///  update_rule: uint8 not null,
///  delete_rule: uint8 not null
/// >
/// The returned data should be ordered by pk_catalog_name, pk_db_schema_name, pk_table_name, pk_key_name, then key_sequence.
/// update_rule and delete_rule returns a byte that is equivalent to actions:
///    - 0 = CASCADE
///    - 1 = RESTRICT
///    - 2 = SET NULL
///    - 3 = NO ACTION
///    - 4 = SET DEFAULT
struct Arrow_Flight_Protocol_Sql_CommandGetCrossReference {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// The catalog name where the parent table is.
  /// An empty string retrieves those without a catalog.
  /// If omitted the catalog name should not be used to narrow the search.
  var pkCatalog: String {
    get {return _pkCatalog ?? String()}
    set {_pkCatalog = newValue}
  }
  /// Returns true if `pkCatalog` has been explicitly set.
  var hasPkCatalog: Bool {return self._pkCatalog != nil}
  /// Clears the value of `pkCatalog`. Subsequent reads from it will return its default value.
  mutating func clearPkCatalog() {self._pkCatalog = nil}

  ///*
  /// The Schema name where the parent table is.
  /// An empty string retrieves those without a schema.
  /// If omitted the schema name should not be used to narrow the search.
  var pkDbSchema: String {
    get {return _pkDbSchema ?? String()}
    set {_pkDbSchema = newValue}
  }
  /// Returns true if `pkDbSchema` has been explicitly set.
  var hasPkDbSchema: Bool {return self._pkDbSchema != nil}
  /// Clears the value of `pkDbSchema`. Subsequent reads from it will return its default value.
  mutating func clearPkDbSchema() {self._pkDbSchema = nil}

  ///*
  /// The parent table name. It cannot be null.
  var pkTable: String = String()

  ///*
  /// The catalog name where the foreign table is.
  /// An empty string retrieves those without a catalog.
  /// If omitted the catalog name should not be used to narrow the search.
  var fkCatalog: String {
    get {return _fkCatalog ?? String()}
    set {_fkCatalog = newValue}
  }
  /// Returns true if `fkCatalog` has been explicitly set.
  var hasFkCatalog: Bool {return self._fkCatalog != nil}
  /// Clears the value of `fkCatalog`. Subsequent reads from it will return its default value.
  mutating func clearFkCatalog() {self._fkCatalog = nil}

  ///*
  /// The schema name where the foreign table is.
  /// An empty string retrieves those without a schema.
  /// If omitted the schema name should not be used to narrow the search.
  var fkDbSchema: String {
    get {return _fkDbSchema ?? String()}
    set {_fkDbSchema = newValue}
  }
  /// Returns true if `fkDbSchema` has been explicitly set.
  var hasFkDbSchema: Bool {return self._fkDbSchema != nil}
  /// Clears the value of `fkDbSchema`. Subsequent reads from it will return its default value.
  mutating func clearFkDbSchema() {self._fkDbSchema = nil}

  ///*
  /// The foreign table name. It cannot be null.
  var fkTable: String = String()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _pkCatalog: String? = nil
  fileprivate var _pkDbSchema: String? = nil
  fileprivate var _fkCatalog: String? = nil
  fileprivate var _fkDbSchema: String? = nil
}

///
/// Request message for the "CreatePreparedStatement" action on a Flight SQL enabled backend.
struct Arrow_Flight_Protocol_Sql_ActionCreatePreparedStatementRequest {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// The valid SQL string to create a prepared statement for.
  var query: String = String()

  /// Create/execute the prepared statement as part of this transaction (if
  /// unset, executions of the prepared statement will be auto-committed).
  var transactionID: Data {
    get {return _transactionID ?? Data()}
    set {_transactionID = newValue}
  }
  /// Returns true if `transactionID` has been explicitly set.
  var hasTransactionID: Bool {return self._transactionID != nil}
  /// Clears the value of `transactionID`. Subsequent reads from it will return its default value.
  mutating func clearTransactionID() {self._transactionID = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _transactionID: Data? = nil
}

///
/// An embedded message describing a Substrait plan to execute.
struct Arrow_Flight_Protocol_Sql_SubstraitPlan {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// The serialized substrait.Plan to create a prepared statement for.
  /// XXX(ARROW-16902): this is bytes instead of an embedded message
  /// because Protobuf does not really support one DLL using Protobuf
  /// definitions from another DLL.
  var plan: Data = Data()

  /// The Substrait release, e.g. "0.12.0". This information is not
  /// tracked in the plan itself, so this is the only way for consumers
  /// to potentially know if they can handle the plan.
  var version: String = String()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///
/// Request message for the "CreatePreparedSubstraitPlan" action on a Flight SQL enabled backend.
struct Arrow_Flight_Protocol_Sql_ActionCreatePreparedSubstraitPlanRequest {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// The serialized substrait.Plan to create a prepared statement for.
  var plan: Arrow_Flight_Protocol_Sql_SubstraitPlan {
    get {return _plan ?? Arrow_Flight_Protocol_Sql_SubstraitPlan()}
    set {_plan = newValue}
  }
  /// Returns true if `plan` has been explicitly set.
  var hasPlan: Bool {return self._plan != nil}
  /// Clears the value of `plan`. Subsequent reads from it will return its default value.
  mutating func clearPlan() {self._plan = nil}

  /// Create/execute the prepared statement as part of this transaction (if
  /// unset, executions of the prepared statement will be auto-committed).
  var transactionID: Data {
    get {return _transactionID ?? Data()}
    set {_transactionID = newValue}
  }
  /// Returns true if `transactionID` has been explicitly set.
  var hasTransactionID: Bool {return self._transactionID != nil}
  /// Clears the value of `transactionID`. Subsequent reads from it will return its default value.
  mutating func clearTransactionID() {self._transactionID = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _plan: Arrow_Flight_Protocol_Sql_SubstraitPlan? = nil
  fileprivate var _transactionID: Data? = nil
}

///
/// Wrap the result of a "CreatePreparedStatement" or "CreatePreparedSubstraitPlan" action.
///
/// The resultant PreparedStatement can be closed either:
/// - Manually, through the "ClosePreparedStatement" action;
/// - Automatically, by a server timeout.
///
/// The result should be wrapped in a google.protobuf.Any message.
struct Arrow_Flight_Protocol_Sql_ActionCreatePreparedStatementResult {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Opaque handle for the prepared statement on the server.
  var preparedStatementHandle: Data = Data()

  /// If a result set generating query was provided, dataset_schema contains the
  /// schema of the dataset as described in Schema.fbs::Schema, it is serialized as an IPC message.
  var datasetSchema: Data = Data()

  /// If the query provided contained parameters, parameter_schema contains the
  /// schema of the expected parameters as described in Schema.fbs::Schema, it is serialized as an IPC message.
  var parameterSchema: Data = Data()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///
/// Request message for the "ClosePreparedStatement" action on a Flight SQL enabled backend.
/// Closes server resources associated with the prepared statement handle.
struct Arrow_Flight_Protocol_Sql_ActionClosePreparedStatementRequest {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Opaque handle for the prepared statement on the server.
  var preparedStatementHandle: Data = Data()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///
/// Request message for the "BeginTransaction" action.
/// Begins a transaction.
struct Arrow_Flight_Protocol_Sql_ActionBeginTransactionRequest {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///
/// Request message for the "BeginSavepoint" action.
/// Creates a savepoint within a transaction.
///
/// Only supported if FLIGHT_SQL_TRANSACTION is
/// FLIGHT_SQL_TRANSACTION_SUPPORT_SAVEPOINT.
struct Arrow_Flight_Protocol_Sql_ActionBeginSavepointRequest {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// The transaction to which a savepoint belongs.
  var transactionID: Data = Data()

  /// Name for the savepoint.
  var name: String = String()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///
/// The result of a "BeginTransaction" action.
///
/// The transaction can be manipulated with the "EndTransaction" action, or
/// automatically via server timeout. If the transaction times out, then it is
/// automatically rolled back.
///
/// The result should be wrapped in a google.protobuf.Any message.
struct Arrow_Flight_Protocol_Sql_ActionBeginTransactionResult {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Opaque handle for the transaction on the server.
  var transactionID: Data = Data()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///
/// The result of a "BeginSavepoint" action.
///
/// The transaction can be manipulated with the "EndSavepoint" action.
/// If the associated transaction is committed, rolled back, or times
/// out, then the savepoint is also invalidated.
///
/// The result should be wrapped in a google.protobuf.Any message.
struct Arrow_Flight_Protocol_Sql_ActionBeginSavepointResult {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Opaque handle for the savepoint on the server.
  var savepointID: Data = Data()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///
/// Request message for the "EndTransaction" action.
///
/// Commit (COMMIT) or rollback (ROLLBACK) the transaction.
///
/// If the action completes successfully, the transaction handle is
/// invalidated, as are all associated savepoints.
struct Arrow_Flight_Protocol_Sql_ActionEndTransactionRequest {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Opaque handle for the transaction on the server.
  var transactionID: Data = Data()

  /// Whether to commit/rollback the given transaction.
  var action: Arrow_Flight_Protocol_Sql_ActionEndTransactionRequest.EndTransaction = .unspecified

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum EndTransaction: SwiftProtobuf.Enum {
    typealias RawValue = Int
    case unspecified // = 0

    /// Commit the transaction.
    case commit // = 1

    /// Roll back the transaction.
    case rollback // = 2
    case UNRECOGNIZED(Int)

    init() {
      self = .unspecified
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .unspecified
      case 1: self = .commit
      case 2: self = .rollback
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .unspecified: return 0
      case .commit: return 1
      case .rollback: return 2
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  init() {}
}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_ActionEndTransactionRequest.EndTransaction: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_ActionEndTransactionRequest.EndTransaction] = [
    .unspecified,
    .commit,
    .rollback,
  ]
}

#endif  // swift(>=4.2)

///
/// Request message for the "EndSavepoint" action.
///
/// Release (RELEASE) the savepoint or rollback (ROLLBACK) to the
/// savepoint.
///
/// Releasing a savepoint invalidates that savepoint.  Rolling back to
/// a savepoint does not invalidate the savepoint, but invalidates all
/// savepoints created after the current savepoint.
struct Arrow_Flight_Protocol_Sql_ActionEndSavepointRequest {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Opaque handle for the savepoint on the server.
  var savepointID: Data = Data()

  /// Whether to rollback/release the given savepoint.
  var action: Arrow_Flight_Protocol_Sql_ActionEndSavepointRequest.EndSavepoint = .unspecified

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum EndSavepoint: SwiftProtobuf.Enum {
    typealias RawValue = Int
    case unspecified // = 0

    /// Release the savepoint.
    case release // = 1

    /// Roll back to a savepoint.
    case rollback // = 2
    case UNRECOGNIZED(Int)

    init() {
      self = .unspecified
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .unspecified
      case 1: self = .release
      case 2: self = .rollback
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .unspecified: return 0
      case .release: return 1
      case .rollback: return 2
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  init() {}
}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_ActionEndSavepointRequest.EndSavepoint: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_ActionEndSavepointRequest.EndSavepoint] = [
    .unspecified,
    .release,
    .rollback,
  ]
}

#endif  // swift(>=4.2)

///
/// Represents a SQL query. Used in the command member of FlightDescriptor
/// for the following RPC calls:
///  - GetSchema: return the Arrow schema of the query.
///    Fields on this schema may contain the following metadata:
///    - ARROW:FLIGHT:SQL:CATALOG_NAME      - Table's catalog name
///    - ARROW:FLIGHT:SQL:DB_SCHEMA_NAME    - Database schema name
///    - ARROW:FLIGHT:SQL:TABLE_NAME        - Table name
///    - ARROW:FLIGHT:SQL:TYPE_NAME         - The data source-specific name for the data type of the column.
///    - ARROW:FLIGHT:SQL:PRECISION         - Column precision/size
///    - ARROW:FLIGHT:SQL:SCALE             - Column scale/decimal digits if applicable
///    - ARROW:FLIGHT:SQL:IS_AUTO_INCREMENT - "1" indicates if the column is auto incremented, "0" otherwise.
///    - ARROW:FLIGHT:SQL:IS_CASE_SENSITIVE - "1" indicates if the column is case-sensitive, "0" otherwise.
///    - ARROW:FLIGHT:SQL:IS_READ_ONLY      - "1" indicates if the column is read only, "0" otherwise.
///    - ARROW:FLIGHT:SQL:IS_SEARCHABLE     - "1" indicates if the column is searchable via WHERE clause, "0" otherwise.
///  - GetFlightInfo: execute the query.
struct Arrow_Flight_Protocol_Sql_CommandStatementQuery {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// The SQL syntax.
  var query: String = String()

  /// Include the query as part of this transaction (if unset, the query is auto-committed).
  var transactionID: Data {
    get {return _transactionID ?? Data()}
    set {_transactionID = newValue}
  }
  /// Returns true if `transactionID` has been explicitly set.
  var hasTransactionID: Bool {return self._transactionID != nil}
  /// Clears the value of `transactionID`. Subsequent reads from it will return its default value.
  mutating func clearTransactionID() {self._transactionID = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _transactionID: Data? = nil
}

///
/// Represents a Substrait plan. Used in the command member of FlightDescriptor
/// for the following RPC calls:
///  - GetSchema: return the Arrow schema of the query.
///    Fields on this schema may contain the following metadata:
///    - ARROW:FLIGHT:SQL:CATALOG_NAME      - Table's catalog name
///    - ARROW:FLIGHT:SQL:DB_SCHEMA_NAME    - Database schema name
///    - ARROW:FLIGHT:SQL:TABLE_NAME        - Table name
///    - ARROW:FLIGHT:SQL:TYPE_NAME         - The data source-specific name for the data type of the column.
///    - ARROW:FLIGHT:SQL:PRECISION         - Column precision/size
///    - ARROW:FLIGHT:SQL:SCALE             - Column scale/decimal digits if applicable
///    - ARROW:FLIGHT:SQL:IS_AUTO_INCREMENT - "1" indicates if the column is auto incremented, "0" otherwise.
///    - ARROW:FLIGHT:SQL:IS_CASE_SENSITIVE - "1" indicates if the column is case-sensitive, "0" otherwise.
///    - ARROW:FLIGHT:SQL:IS_READ_ONLY      - "1" indicates if the column is read only, "0" otherwise.
///    - ARROW:FLIGHT:SQL:IS_SEARCHABLE     - "1" indicates if the column is searchable via WHERE clause, "0" otherwise.
///  - GetFlightInfo: execute the query.
///  - DoPut: execute the query.
struct Arrow_Flight_Protocol_Sql_CommandStatementSubstraitPlan {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// A serialized substrait.Plan
  var plan: Arrow_Flight_Protocol_Sql_SubstraitPlan {
    get {return _plan ?? Arrow_Flight_Protocol_Sql_SubstraitPlan()}
    set {_plan = newValue}
  }
  /// Returns true if `plan` has been explicitly set.
  var hasPlan: Bool {return self._plan != nil}
  /// Clears the value of `plan`. Subsequent reads from it will return its default value.
  mutating func clearPlan() {self._plan = nil}

  /// Include the query as part of this transaction (if unset, the query is auto-committed).
  var transactionID: Data {
    get {return _transactionID ?? Data()}
    set {_transactionID = newValue}
  }
  /// Returns true if `transactionID` has been explicitly set.
  var hasTransactionID: Bool {return self._transactionID != nil}
  /// Clears the value of `transactionID`. Subsequent reads from it will return its default value.
  mutating func clearTransactionID() {self._transactionID = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _plan: Arrow_Flight_Protocol_Sql_SubstraitPlan? = nil
  fileprivate var _transactionID: Data? = nil
}

///*
/// Represents a ticket resulting from GetFlightInfo with a CommandStatementQuery.
/// This should be used only once and treated as an opaque value, that is, clients should not attempt to parse this.
struct Arrow_Flight_Protocol_Sql_TicketStatementQuery {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Unique identifier for the instance of the statement to execute.
  var statementHandle: Data = Data()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///
/// Represents an instance of executing a prepared statement. Used in the command member of FlightDescriptor for
/// the following RPC calls:
///  - GetSchema: return the Arrow schema of the query.
///    Fields on this schema may contain the following metadata:
///    - ARROW:FLIGHT:SQL:CATALOG_NAME      - Table's catalog name
///    - ARROW:FLIGHT:SQL:DB_SCHEMA_NAME    - Database schema name
///    - ARROW:FLIGHT:SQL:TABLE_NAME        - Table name
///    - ARROW:FLIGHT:SQL:TYPE_NAME         - The data source-specific name for the data type of the column.
///    - ARROW:FLIGHT:SQL:PRECISION         - Column precision/size
///    - ARROW:FLIGHT:SQL:SCALE             - Column scale/decimal digits if applicable
///    - ARROW:FLIGHT:SQL:IS_AUTO_INCREMENT - "1" indicates if the column is auto incremented, "0" otherwise.
///    - ARROW:FLIGHT:SQL:IS_CASE_SENSITIVE - "1" indicates if the column is case-sensitive, "0" otherwise.
///    - ARROW:FLIGHT:SQL:IS_READ_ONLY      - "1" indicates if the column is read only, "0" otherwise.
///    - ARROW:FLIGHT:SQL:IS_SEARCHABLE     - "1" indicates if the column is searchable via WHERE clause, "0" otherwise.
///  - DoPut: bind parameter values. All of the bound parameter sets will be executed as a single atomic execution.
///  - GetFlightInfo: execute the prepared statement instance.
struct Arrow_Flight_Protocol_Sql_CommandPreparedStatementQuery {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Opaque handle for the prepared statement on the server.
  var preparedStatementHandle: Data = Data()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///
/// Represents a SQL update query. Used in the command member of FlightDescriptor
/// for the RPC call DoPut to cause the server to execute the included SQL update.
struct Arrow_Flight_Protocol_Sql_CommandStatementUpdate {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// The SQL syntax.
  var query: String = String()

  /// Include the query as part of this transaction (if unset, the query is auto-committed).
  var transactionID: Data {
    get {return _transactionID ?? Data()}
    set {_transactionID = newValue}
  }
  /// Returns true if `transactionID` has been explicitly set.
  var hasTransactionID: Bool {return self._transactionID != nil}
  /// Clears the value of `transactionID`. Subsequent reads from it will return its default value.
  mutating func clearTransactionID() {self._transactionID = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _transactionID: Data? = nil
}

///
/// Represents a SQL update query. Used in the command member of FlightDescriptor
/// for the RPC call DoPut to cause the server to execute the included
/// prepared statement handle as an update.
struct Arrow_Flight_Protocol_Sql_CommandPreparedStatementUpdate {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Opaque handle for the prepared statement on the server.
  var preparedStatementHandle: Data = Data()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///
/// Returned from the RPC call DoPut when a CommandStatementUpdate
/// CommandPreparedStatementUpdate was in the request, containing
/// results from the update.
struct Arrow_Flight_Protocol_Sql_DoPutUpdateResult {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// The number of records updated. A return value of -1 represents
  /// an unknown updated record count.
  var recordCount: Int64 = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///
/// Request message for the "CancelQuery" action.
///
/// Explicitly cancel a running query.
///
/// This lets a single client explicitly cancel work, no matter how many clients
/// are involved/whether the query is distributed or not, given server support.
/// The transaction/statement is not rolled back; it is the application's job to
/// commit or rollback as appropriate. This only indicates the client no longer
/// wishes to read the remainder of the query results or continue submitting
/// data.
///
/// This command is idempotent.
///
/// This command is deprecated since 13.0.0. Use the "CancelFlightInfo"
/// action with DoAction instead.
struct Arrow_Flight_Protocol_Sql_ActionCancelQueryRequest {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// The result of the GetFlightInfo RPC that initiated the query.
  /// XXX(ARROW-16902): this must be a serialized FlightInfo, but is
  /// rendered as bytes because Protobuf does not really support one
  /// DLL using Protobuf definitions from another DLL.
  var info: Data = Data()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///
/// The result of cancelling a query.
///
/// The result should be wrapped in a google.protobuf.Any message.
///
/// This command is deprecated since 13.0.0. Use the "CancelFlightInfo"
/// action with DoAction instead.
struct Arrow_Flight_Protocol_Sql_ActionCancelQueryResult {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var result: Arrow_Flight_Protocol_Sql_ActionCancelQueryResult.CancelResult = .unspecified

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum CancelResult: SwiftProtobuf.Enum {
    typealias RawValue = Int

    /// The cancellation status is unknown. Servers should avoid using
    /// this value (send a NOT_FOUND error if the requested query is
    /// not known). Clients can retry the request.
    case unspecified // = 0

    /// The cancellation request is complete. Subsequent requests with
    /// the same payload may return CANCELLED or a NOT_FOUND error.
    case cancelled // = 1

    /// The cancellation request is in progress. The client may retry
    /// the cancellation request.
    case cancelling // = 2

    /// The query is not cancellable. The client should not retry the
    /// cancellation request.
    case notCancellable // = 3
    case UNRECOGNIZED(Int)

    init() {
      self = .unspecified
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .unspecified
      case 1: self = .cancelled
      case 2: self = .cancelling
      case 3: self = .notCancellable
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .unspecified: return 0
      case .cancelled: return 1
      case .cancelling: return 2
      case .notCancellable: return 3
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  init() {}
}

#if swift(>=4.2)

extension Arrow_Flight_Protocol_Sql_ActionCancelQueryResult.CancelResult: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [Arrow_Flight_Protocol_Sql_ActionCancelQueryResult.CancelResult] = [
    .unspecified,
    .cancelled,
    .cancelling,
    .notCancellable,
  ]
}

#endif  // swift(>=4.2)

#if swift(>=5.5) && canImport(_Concurrency)
extension Arrow_Flight_Protocol_Sql_SqlInfo: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_SqlSupportedTransaction: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_SqlSupportedCaseSensitivity: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_SqlNullOrdering: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_SupportedSqlGrammar: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_SupportedAnsi92SqlGrammarLevel: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_SqlOuterJoinsSupportLevel: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_SqlSupportedGroupBy: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_SqlSupportedElementActions: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_SqlSupportedPositionedCommands: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_SqlSupportedSubqueries: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_SqlSupportedUnions: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_SqlTransactionIsolationLevel: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_SqlSupportedTransactions: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_SqlSupportedResultSetType: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_SqlSupportedResultSetConcurrency: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_SqlSupportsConvert: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_XdbcDataType: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_XdbcDatetimeSubcode: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_Nullable: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_Searchable: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_UpdateDeleteRules: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_CommandGetSqlInfo: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_CommandGetXdbcTypeInfo: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_CommandGetCatalogs: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_CommandGetDbSchemas: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_CommandGetTables: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_CommandGetTableTypes: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_CommandGetPrimaryKeys: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_CommandGetExportedKeys: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_CommandGetImportedKeys: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_CommandGetCrossReference: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_ActionCreatePreparedStatementRequest: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_SubstraitPlan: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_ActionCreatePreparedSubstraitPlanRequest: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_ActionCreatePreparedStatementResult: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_ActionClosePreparedStatementRequest: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_ActionBeginTransactionRequest: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_ActionBeginSavepointRequest: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_ActionBeginTransactionResult: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_ActionBeginSavepointResult: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_ActionEndTransactionRequest: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_ActionEndTransactionRequest.EndTransaction: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_ActionEndSavepointRequest: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_ActionEndSavepointRequest.EndSavepoint: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_CommandStatementQuery: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_CommandStatementSubstraitPlan: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_TicketStatementQuery: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_CommandPreparedStatementQuery: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_CommandStatementUpdate: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_CommandPreparedStatementUpdate: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_DoPutUpdateResult: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_ActionCancelQueryRequest: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_ActionCancelQueryResult: @unchecked Sendable {}
extension Arrow_Flight_Protocol_Sql_ActionCancelQueryResult.CancelResult: @unchecked Sendable {}
#endif  // swift(>=5.5) && canImport(_Concurrency)

// MARK: - Extension support defined in FlightSql.proto.

// MARK: - Extension Properties

// Swift Extensions on the extended Messages to add easy access to the declared
// extension fields. The names are based on the extension field name from the proto
// declaration. To avoid naming collisions, the names are prefixed with the name of
// the scope where the extend directive occurs.

extension SwiftProtobuf.Google_Protobuf_MessageOptions {

  var Arrow_Flight_Protocol_Sql_experimental: Bool {
    get {return getExtensionValue(ext: Arrow_Flight_Protocol_Sql_Extensions_experimental) ?? false}
    set {setExtensionValue(ext: Arrow_Flight_Protocol_Sql_Extensions_experimental, value: newValue)}
  }
  /// Returns true if extension `Arrow_Flight_Protocol_Sql_Extensions_experimental`
  /// has been explicitly set.
  var hasArrow_Flight_Protocol_Sql_experimental: Bool {
    return hasExtensionValue(ext: Arrow_Flight_Protocol_Sql_Extensions_experimental)
  }
  /// Clears the value of extension `Arrow_Flight_Protocol_Sql_Extensions_experimental`.
  /// Subsequent reads from it will return its default value.
  mutating func clearArrow_Flight_Protocol_Sql_experimental() {
    clearExtensionValue(ext: Arrow_Flight_Protocol_Sql_Extensions_experimental)
  }

}

// MARK: - File's ExtensionMap: Arrow_Flight_Protocol_Sql_FlightSql_Extensions

/// A `SwiftProtobuf.SimpleExtensionMap` that includes all of the extensions defined by
/// this .proto file. It can be used any place an `SwiftProtobuf.ExtensionMap` is needed
/// in parsing, or it can be combined with other `SwiftProtobuf.SimpleExtensionMap`s to create
/// a larger `SwiftProtobuf.SimpleExtensionMap`.
let Arrow_Flight_Protocol_Sql_FlightSql_Extensions: SwiftProtobuf.SimpleExtensionMap = [
  Arrow_Flight_Protocol_Sql_Extensions_experimental
]

// Extension Objects - The only reason these might be needed is when manually
// constructing a `SimpleExtensionMap`, otherwise, use the above _Extension Properties_
// accessors for the extension fields on the messages directly.

let Arrow_Flight_Protocol_Sql_Extensions_experimental = SwiftProtobuf.MessageExtension<SwiftProtobuf.OptionalExtensionField<SwiftProtobuf.ProtobufBool>, SwiftProtobuf.Google_Protobuf_MessageOptions>(
  _protobuf_fieldNumber: 1000,
  fieldName: "arrow.flight.protocol.sql.experimental"
)

// MARK: - Code below here is support for the SwiftProtobuf runtime.

fileprivate let _protobuf_package = "arrow.flight.protocol.sql"

extension Arrow_Flight_Protocol_Sql_SqlInfo: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "FLIGHT_SQL_SERVER_NAME"),
    1: .same(proto: "FLIGHT_SQL_SERVER_VERSION"),
    2: .same(proto: "FLIGHT_SQL_SERVER_ARROW_VERSION"),
    3: .same(proto: "FLIGHT_SQL_SERVER_READ_ONLY"),
    4: .same(proto: "FLIGHT_SQL_SERVER_SQL"),
    5: .same(proto: "FLIGHT_SQL_SERVER_SUBSTRAIT"),
    6: .same(proto: "FLIGHT_SQL_SERVER_SUBSTRAIT_MIN_VERSION"),
    7: .same(proto: "FLIGHT_SQL_SERVER_SUBSTRAIT_MAX_VERSION"),
    8: .same(proto: "FLIGHT_SQL_SERVER_TRANSACTION"),
    9: .same(proto: "FLIGHT_SQL_SERVER_CANCEL"),
    100: .same(proto: "FLIGHT_SQL_SERVER_STATEMENT_TIMEOUT"),
    101: .same(proto: "FLIGHT_SQL_SERVER_TRANSACTION_TIMEOUT"),
    500: .same(proto: "SQL_DDL_CATALOG"),
    501: .same(proto: "SQL_DDL_SCHEMA"),
    502: .same(proto: "SQL_DDL_TABLE"),
    503: .same(proto: "SQL_IDENTIFIER_CASE"),
    504: .same(proto: "SQL_IDENTIFIER_QUOTE_CHAR"),
    505: .same(proto: "SQL_QUOTED_IDENTIFIER_CASE"),
    506: .same(proto: "SQL_ALL_TABLES_ARE_SELECTABLE"),
    507: .same(proto: "SQL_NULL_ORDERING"),
    508: .same(proto: "SQL_KEYWORDS"),
    509: .same(proto: "SQL_NUMERIC_FUNCTIONS"),
    510: .same(proto: "SQL_STRING_FUNCTIONS"),
    511: .same(proto: "SQL_SYSTEM_FUNCTIONS"),
    512: .same(proto: "SQL_DATETIME_FUNCTIONS"),
    513: .same(proto: "SQL_SEARCH_STRING_ESCAPE"),
    514: .same(proto: "SQL_EXTRA_NAME_CHARACTERS"),
    515: .same(proto: "SQL_SUPPORTS_COLUMN_ALIASING"),
    516: .same(proto: "SQL_NULL_PLUS_NULL_IS_NULL"),
    517: .same(proto: "SQL_SUPPORTS_CONVERT"),
    518: .same(proto: "SQL_SUPPORTS_TABLE_CORRELATION_NAMES"),
    519: .same(proto: "SQL_SUPPORTS_DIFFERENT_TABLE_CORRELATION_NAMES"),
    520: .same(proto: "SQL_SUPPORTS_EXPRESSIONS_IN_ORDER_BY"),
    521: .same(proto: "SQL_SUPPORTS_ORDER_BY_UNRELATED"),
    522: .same(proto: "SQL_SUPPORTED_GROUP_BY"),
    523: .same(proto: "SQL_SUPPORTS_LIKE_ESCAPE_CLAUSE"),
    524: .same(proto: "SQL_SUPPORTS_NON_NULLABLE_COLUMNS"),
    525: .same(proto: "SQL_SUPPORTED_GRAMMAR"),
    526: .same(proto: "SQL_ANSI92_SUPPORTED_LEVEL"),
    527: .same(proto: "SQL_SUPPORTS_INTEGRITY_ENHANCEMENT_FACILITY"),
    528: .same(proto: "SQL_OUTER_JOINS_SUPPORT_LEVEL"),
    529: .same(proto: "SQL_SCHEMA_TERM"),
    530: .same(proto: "SQL_PROCEDURE_TERM"),
    531: .same(proto: "SQL_CATALOG_TERM"),
    532: .same(proto: "SQL_CATALOG_AT_START"),
    533: .same(proto: "SQL_SCHEMAS_SUPPORTED_ACTIONS"),
    534: .same(proto: "SQL_CATALOGS_SUPPORTED_ACTIONS"),
    535: .same(proto: "SQL_SUPPORTED_POSITIONED_COMMANDS"),
    536: .same(proto: "SQL_SELECT_FOR_UPDATE_SUPPORTED"),
    537: .same(proto: "SQL_STORED_PROCEDURES_SUPPORTED"),
    538: .same(proto: "SQL_SUPPORTED_SUBQUERIES"),
    539: .same(proto: "SQL_CORRELATED_SUBQUERIES_SUPPORTED"),
    540: .same(proto: "SQL_SUPPORTED_UNIONS"),
    541: .same(proto: "SQL_MAX_BINARY_LITERAL_LENGTH"),
    542: .same(proto: "SQL_MAX_CHAR_LITERAL_LENGTH"),
    543: .same(proto: "SQL_MAX_COLUMN_NAME_LENGTH"),
    544: .same(proto: "SQL_MAX_COLUMNS_IN_GROUP_BY"),
    545: .same(proto: "SQL_MAX_COLUMNS_IN_INDEX"),
    546: .same(proto: "SQL_MAX_COLUMNS_IN_ORDER_BY"),
    547: .same(proto: "SQL_MAX_COLUMNS_IN_SELECT"),
    548: .same(proto: "SQL_MAX_COLUMNS_IN_TABLE"),
    549: .same(proto: "SQL_MAX_CONNECTIONS"),
    550: .same(proto: "SQL_MAX_CURSOR_NAME_LENGTH"),
    551: .same(proto: "SQL_MAX_INDEX_LENGTH"),
    552: .same(proto: "SQL_DB_SCHEMA_NAME_LENGTH"),
    553: .same(proto: "SQL_MAX_PROCEDURE_NAME_LENGTH"),
    554: .same(proto: "SQL_MAX_CATALOG_NAME_LENGTH"),
    555: .same(proto: "SQL_MAX_ROW_SIZE"),
    556: .same(proto: "SQL_MAX_ROW_SIZE_INCLUDES_BLOBS"),
    557: .same(proto: "SQL_MAX_STATEMENT_LENGTH"),
    558: .same(proto: "SQL_MAX_STATEMENTS"),
    559: .same(proto: "SQL_MAX_TABLE_NAME_LENGTH"),
    560: .same(proto: "SQL_MAX_TABLES_IN_SELECT"),
    561: .same(proto: "SQL_MAX_USERNAME_LENGTH"),
    562: .same(proto: "SQL_DEFAULT_TRANSACTION_ISOLATION"),
    563: .same(proto: "SQL_TRANSACTIONS_SUPPORTED"),
    564: .same(proto: "SQL_SUPPORTED_TRANSACTIONS_ISOLATION_LEVELS"),
    565: .same(proto: "SQL_DATA_DEFINITION_CAUSES_TRANSACTION_COMMIT"),
    566: .same(proto: "SQL_DATA_DEFINITIONS_IN_TRANSACTIONS_IGNORED"),
    567: .same(proto: "SQL_SUPPORTED_RESULT_SET_TYPES"),
    568: .same(proto: "SQL_SUPPORTED_CONCURRENCIES_FOR_RESULT_SET_UNSPECIFIED"),
    569: .same(proto: "SQL_SUPPORTED_CONCURRENCIES_FOR_RESULT_SET_FORWARD_ONLY"),
    570: .same(proto: "SQL_SUPPORTED_CONCURRENCIES_FOR_RESULT_SET_SCROLL_SENSITIVE"),
    571: .same(proto: "SQL_SUPPORTED_CONCURRENCIES_FOR_RESULT_SET_SCROLL_INSENSITIVE"),
    572: .same(proto: "SQL_BATCH_UPDATES_SUPPORTED"),
    573: .same(proto: "SQL_SAVEPOINTS_SUPPORTED"),
    574: .same(proto: "SQL_NAMED_PARAMETERS_SUPPORTED"),
    575: .same(proto: "SQL_LOCATORS_UPDATE_COPY"),
    576: .same(proto: "SQL_STORED_FUNCTIONS_USING_CALL_SYNTAX_SUPPORTED"),
  ]
}

extension Arrow_Flight_Protocol_Sql_SqlSupportedTransaction: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SQL_SUPPORTED_TRANSACTION_NONE"),
    1: .same(proto: "SQL_SUPPORTED_TRANSACTION_TRANSACTION"),
    2: .same(proto: "SQL_SUPPORTED_TRANSACTION_SAVEPOINT"),
  ]
}

extension Arrow_Flight_Protocol_Sql_SqlSupportedCaseSensitivity: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SQL_CASE_SENSITIVITY_UNKNOWN"),
    1: .same(proto: "SQL_CASE_SENSITIVITY_CASE_INSENSITIVE"),
    2: .same(proto: "SQL_CASE_SENSITIVITY_UPPERCASE"),
    3: .same(proto: "SQL_CASE_SENSITIVITY_LOWERCASE"),
  ]
}

extension Arrow_Flight_Protocol_Sql_SqlNullOrdering: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SQL_NULLS_SORTED_HIGH"),
    1: .same(proto: "SQL_NULLS_SORTED_LOW"),
    2: .same(proto: "SQL_NULLS_SORTED_AT_START"),
    3: .same(proto: "SQL_NULLS_SORTED_AT_END"),
  ]
}

extension Arrow_Flight_Protocol_Sql_SupportedSqlGrammar: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SQL_MINIMUM_GRAMMAR"),
    1: .same(proto: "SQL_CORE_GRAMMAR"),
    2: .same(proto: "SQL_EXTENDED_GRAMMAR"),
  ]
}

extension Arrow_Flight_Protocol_Sql_SupportedAnsi92SqlGrammarLevel: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "ANSI92_ENTRY_SQL"),
    1: .same(proto: "ANSI92_INTERMEDIATE_SQL"),
    2: .same(proto: "ANSI92_FULL_SQL"),
  ]
}

extension Arrow_Flight_Protocol_Sql_SqlOuterJoinsSupportLevel: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SQL_JOINS_UNSUPPORTED"),
    1: .same(proto: "SQL_LIMITED_OUTER_JOINS"),
    2: .same(proto: "SQL_FULL_OUTER_JOINS"),
  ]
}

extension Arrow_Flight_Protocol_Sql_SqlSupportedGroupBy: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SQL_GROUP_BY_UNRELATED"),
    1: .same(proto: "SQL_GROUP_BY_BEYOND_SELECT"),
  ]
}

extension Arrow_Flight_Protocol_Sql_SqlSupportedElementActions: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SQL_ELEMENT_IN_PROCEDURE_CALLS"),
    1: .same(proto: "SQL_ELEMENT_IN_INDEX_DEFINITIONS"),
    2: .same(proto: "SQL_ELEMENT_IN_PRIVILEGE_DEFINITIONS"),
  ]
}

extension Arrow_Flight_Protocol_Sql_SqlSupportedPositionedCommands: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SQL_POSITIONED_DELETE"),
    1: .same(proto: "SQL_POSITIONED_UPDATE"),
  ]
}

extension Arrow_Flight_Protocol_Sql_SqlSupportedSubqueries: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SQL_SUBQUERIES_IN_COMPARISONS"),
    1: .same(proto: "SQL_SUBQUERIES_IN_EXISTS"),
    2: .same(proto: "SQL_SUBQUERIES_IN_INS"),
    3: .same(proto: "SQL_SUBQUERIES_IN_QUANTIFIEDS"),
  ]
}

extension Arrow_Flight_Protocol_Sql_SqlSupportedUnions: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SQL_UNION"),
    1: .same(proto: "SQL_UNION_ALL"),
  ]
}

extension Arrow_Flight_Protocol_Sql_SqlTransactionIsolationLevel: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SQL_TRANSACTION_NONE"),
    1: .same(proto: "SQL_TRANSACTION_READ_UNCOMMITTED"),
    2: .same(proto: "SQL_TRANSACTION_READ_COMMITTED"),
    3: .same(proto: "SQL_TRANSACTION_REPEATABLE_READ"),
    4: .same(proto: "SQL_TRANSACTION_SERIALIZABLE"),
  ]
}

extension Arrow_Flight_Protocol_Sql_SqlSupportedTransactions: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SQL_TRANSACTION_UNSPECIFIED"),
    1: .same(proto: "SQL_DATA_DEFINITION_TRANSACTIONS"),
    2: .same(proto: "SQL_DATA_MANIPULATION_TRANSACTIONS"),
  ]
}

extension Arrow_Flight_Protocol_Sql_SqlSupportedResultSetType: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SQL_RESULT_SET_TYPE_UNSPECIFIED"),
    1: .same(proto: "SQL_RESULT_SET_TYPE_FORWARD_ONLY"),
    2: .same(proto: "SQL_RESULT_SET_TYPE_SCROLL_INSENSITIVE"),
    3: .same(proto: "SQL_RESULT_SET_TYPE_SCROLL_SENSITIVE"),
  ]
}

extension Arrow_Flight_Protocol_Sql_SqlSupportedResultSetConcurrency: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SQL_RESULT_SET_CONCURRENCY_UNSPECIFIED"),
    1: .same(proto: "SQL_RESULT_SET_CONCURRENCY_READ_ONLY"),
    2: .same(proto: "SQL_RESULT_SET_CONCURRENCY_UPDATABLE"),
  ]
}

extension Arrow_Flight_Protocol_Sql_SqlSupportsConvert: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SQL_CONVERT_BIGINT"),
    1: .same(proto: "SQL_CONVERT_BINARY"),
    2: .same(proto: "SQL_CONVERT_BIT"),
    3: .same(proto: "SQL_CONVERT_CHAR"),
    4: .same(proto: "SQL_CONVERT_DATE"),
    5: .same(proto: "SQL_CONVERT_DECIMAL"),
    6: .same(proto: "SQL_CONVERT_FLOAT"),
    7: .same(proto: "SQL_CONVERT_INTEGER"),
    8: .same(proto: "SQL_CONVERT_INTERVAL_DAY_TIME"),
    9: .same(proto: "SQL_CONVERT_INTERVAL_YEAR_MONTH"),
    10: .same(proto: "SQL_CONVERT_LONGVARBINARY"),
    11: .same(proto: "SQL_CONVERT_LONGVARCHAR"),
    12: .same(proto: "SQL_CONVERT_NUMERIC"),
    13: .same(proto: "SQL_CONVERT_REAL"),
    14: .same(proto: "SQL_CONVERT_SMALLINT"),
    15: .same(proto: "SQL_CONVERT_TIME"),
    16: .same(proto: "SQL_CONVERT_TIMESTAMP"),
    17: .same(proto: "SQL_CONVERT_TINYINT"),
    18: .same(proto: "SQL_CONVERT_VARBINARY"),
    19: .same(proto: "SQL_CONVERT_VARCHAR"),
  ]
}

extension Arrow_Flight_Protocol_Sql_XdbcDataType: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    -9: .same(proto: "XDBC_WVARCHAR"),
    -8: .same(proto: "XDBC_WCHAR"),
    -7: .same(proto: "XDBC_BIT"),
    -6: .same(proto: "XDBC_TINYINT"),
    -5: .same(proto: "XDBC_BIGINT"),
    -4: .same(proto: "XDBC_LONGVARBINARY"),
    -3: .same(proto: "XDBC_VARBINARY"),
    -2: .same(proto: "XDBC_BINARY"),
    -1: .same(proto: "XDBC_LONGVARCHAR"),
    0: .same(proto: "XDBC_UNKNOWN_TYPE"),
    1: .same(proto: "XDBC_CHAR"),
    2: .same(proto: "XDBC_NUMERIC"),
    3: .same(proto: "XDBC_DECIMAL"),
    4: .same(proto: "XDBC_INTEGER"),
    5: .same(proto: "XDBC_SMALLINT"),
    6: .same(proto: "XDBC_FLOAT"),
    7: .same(proto: "XDBC_REAL"),
    8: .same(proto: "XDBC_DOUBLE"),
    9: .same(proto: "XDBC_DATETIME"),
    10: .same(proto: "XDBC_INTERVAL"),
    12: .same(proto: "XDBC_VARCHAR"),
    91: .same(proto: "XDBC_DATE"),
    92: .same(proto: "XDBC_TIME"),
    93: .same(proto: "XDBC_TIMESTAMP"),
  ]
}

extension Arrow_Flight_Protocol_Sql_XdbcDatetimeSubcode: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "XDBC_SUBCODE_UNKNOWN"),
    1: .aliased(proto: "XDBC_SUBCODE_YEAR", aliases: ["XDBC_SUBCODE_DATE"]),
    2: .aliased(proto: "XDBC_SUBCODE_TIME", aliases: ["XDBC_SUBCODE_MONTH"]),
    3: .aliased(proto: "XDBC_SUBCODE_TIMESTAMP", aliases: ["XDBC_SUBCODE_DAY"]),
    4: .aliased(proto: "XDBC_SUBCODE_TIME_WITH_TIMEZONE", aliases: ["XDBC_SUBCODE_HOUR"]),
    5: .aliased(proto: "XDBC_SUBCODE_TIMESTAMP_WITH_TIMEZONE", aliases: ["XDBC_SUBCODE_MINUTE"]),
    6: .same(proto: "XDBC_SUBCODE_SECOND"),
    7: .same(proto: "XDBC_SUBCODE_YEAR_TO_MONTH"),
    8: .same(proto: "XDBC_SUBCODE_DAY_TO_HOUR"),
    9: .same(proto: "XDBC_SUBCODE_DAY_TO_MINUTE"),
    10: .same(proto: "XDBC_SUBCODE_DAY_TO_SECOND"),
    11: .same(proto: "XDBC_SUBCODE_HOUR_TO_MINUTE"),
    12: .same(proto: "XDBC_SUBCODE_HOUR_TO_SECOND"),
    13: .same(proto: "XDBC_SUBCODE_MINUTE_TO_SECOND"),
    101: .same(proto: "XDBC_SUBCODE_INTERVAL_YEAR"),
    102: .same(proto: "XDBC_SUBCODE_INTERVAL_MONTH"),
    103: .same(proto: "XDBC_SUBCODE_INTERVAL_DAY"),
    104: .same(proto: "XDBC_SUBCODE_INTERVAL_HOUR"),
    105: .same(proto: "XDBC_SUBCODE_INTERVAL_MINUTE"),
    106: .same(proto: "XDBC_SUBCODE_INTERVAL_SECOND"),
    107: .same(proto: "XDBC_SUBCODE_INTERVAL_YEAR_TO_MONTH"),
    108: .same(proto: "XDBC_SUBCODE_INTERVAL_DAY_TO_HOUR"),
    109: .same(proto: "XDBC_SUBCODE_INTERVAL_DAY_TO_MINUTE"),
    110: .same(proto: "XDBC_SUBCODE_INTERVAL_DAY_TO_SECOND"),
    111: .same(proto: "XDBC_SUBCODE_INTERVAL_HOUR_TO_MINUTE"),
    112: .same(proto: "XDBC_SUBCODE_INTERVAL_HOUR_TO_SECOND"),
    113: .same(proto: "XDBC_SUBCODE_INTERVAL_MINUTE_TO_SECOND"),
  ]
}

extension Arrow_Flight_Protocol_Sql_Nullable: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "NULLABILITY_NO_NULLS"),
    1: .same(proto: "NULLABILITY_NULLABLE"),
    2: .same(proto: "NULLABILITY_UNKNOWN"),
  ]
}

extension Arrow_Flight_Protocol_Sql_Searchable: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SEARCHABLE_NONE"),
    1: .same(proto: "SEARCHABLE_CHAR"),
    2: .same(proto: "SEARCHABLE_BASIC"),
    3: .same(proto: "SEARCHABLE_FULL"),
  ]
}

extension Arrow_Flight_Protocol_Sql_UpdateDeleteRules: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "CASCADE"),
    1: .same(proto: "RESTRICT"),
    2: .same(proto: "SET_NULL"),
    3: .same(proto: "NO_ACTION"),
    4: .same(proto: "SET_DEFAULT"),
  ]
}

extension Arrow_Flight_Protocol_Sql_CommandGetSqlInfo: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CommandGetSqlInfo"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "info"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedUInt32Field(value: &self.info) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.info.isEmpty {
      try visitor.visitPackedUInt32Field(value: self.info, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_CommandGetSqlInfo, rhs: Arrow_Flight_Protocol_Sql_CommandGetSqlInfo) -> Bool {
    if lhs.info != rhs.info {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_CommandGetXdbcTypeInfo: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CommandGetXdbcTypeInfo"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "data_type"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt32Field(value: &self._dataType) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._dataType {
      try visitor.visitSingularInt32Field(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_CommandGetXdbcTypeInfo, rhs: Arrow_Flight_Protocol_Sql_CommandGetXdbcTypeInfo) -> Bool {
    if lhs._dataType != rhs._dataType {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_CommandGetCatalogs: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CommandGetCatalogs"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_CommandGetCatalogs, rhs: Arrow_Flight_Protocol_Sql_CommandGetCatalogs) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_CommandGetDbSchemas: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CommandGetDbSchemas"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "catalog"),
    2: .standard(proto: "db_schema_filter_pattern"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self._catalog) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._dbSchemaFilterPattern) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._catalog {
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._dbSchemaFilterPattern {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_CommandGetDbSchemas, rhs: Arrow_Flight_Protocol_Sql_CommandGetDbSchemas) -> Bool {
    if lhs._catalog != rhs._catalog {return false}
    if lhs._dbSchemaFilterPattern != rhs._dbSchemaFilterPattern {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_CommandGetTables: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CommandGetTables"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "catalog"),
    2: .standard(proto: "db_schema_filter_pattern"),
    3: .standard(proto: "table_name_filter_pattern"),
    4: .standard(proto: "table_types"),
    5: .standard(proto: "include_schema"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self._catalog) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._dbSchemaFilterPattern) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self._tableNameFilterPattern) }()
      case 4: try { try decoder.decodeRepeatedStringField(value: &self.tableTypes) }()
      case 5: try { try decoder.decodeSingularBoolField(value: &self.includeSchema) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._catalog {
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._dbSchemaFilterPattern {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    try { if let v = self._tableNameFilterPattern {
      try visitor.visitSingularStringField(value: v, fieldNumber: 3)
    } }()
    if !self.tableTypes.isEmpty {
      try visitor.visitRepeatedStringField(value: self.tableTypes, fieldNumber: 4)
    }
    if self.includeSchema != false {
      try visitor.visitSingularBoolField(value: self.includeSchema, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_CommandGetTables, rhs: Arrow_Flight_Protocol_Sql_CommandGetTables) -> Bool {
    if lhs._catalog != rhs._catalog {return false}
    if lhs._dbSchemaFilterPattern != rhs._dbSchemaFilterPattern {return false}
    if lhs._tableNameFilterPattern != rhs._tableNameFilterPattern {return false}
    if lhs.tableTypes != rhs.tableTypes {return false}
    if lhs.includeSchema != rhs.includeSchema {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_CommandGetTableTypes: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CommandGetTableTypes"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_CommandGetTableTypes, rhs: Arrow_Flight_Protocol_Sql_CommandGetTableTypes) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_CommandGetPrimaryKeys: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CommandGetPrimaryKeys"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "catalog"),
    2: .standard(proto: "db_schema"),
    3: .same(proto: "table"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self._catalog) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._dbSchema) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.table) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._catalog {
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._dbSchema {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    if !self.table.isEmpty {
      try visitor.visitSingularStringField(value: self.table, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_CommandGetPrimaryKeys, rhs: Arrow_Flight_Protocol_Sql_CommandGetPrimaryKeys) -> Bool {
    if lhs._catalog != rhs._catalog {return false}
    if lhs._dbSchema != rhs._dbSchema {return false}
    if lhs.table != rhs.table {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_CommandGetExportedKeys: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CommandGetExportedKeys"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "catalog"),
    2: .standard(proto: "db_schema"),
    3: .same(proto: "table"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self._catalog) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._dbSchema) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.table) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._catalog {
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._dbSchema {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    if !self.table.isEmpty {
      try visitor.visitSingularStringField(value: self.table, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_CommandGetExportedKeys, rhs: Arrow_Flight_Protocol_Sql_CommandGetExportedKeys) -> Bool {
    if lhs._catalog != rhs._catalog {return false}
    if lhs._dbSchema != rhs._dbSchema {return false}
    if lhs.table != rhs.table {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_CommandGetImportedKeys: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CommandGetImportedKeys"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "catalog"),
    2: .standard(proto: "db_schema"),
    3: .same(proto: "table"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self._catalog) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._dbSchema) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.table) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._catalog {
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._dbSchema {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    if !self.table.isEmpty {
      try visitor.visitSingularStringField(value: self.table, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_CommandGetImportedKeys, rhs: Arrow_Flight_Protocol_Sql_CommandGetImportedKeys) -> Bool {
    if lhs._catalog != rhs._catalog {return false}
    if lhs._dbSchema != rhs._dbSchema {return false}
    if lhs.table != rhs.table {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_CommandGetCrossReference: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CommandGetCrossReference"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "pk_catalog"),
    2: .standard(proto: "pk_db_schema"),
    3: .standard(proto: "pk_table"),
    4: .standard(proto: "fk_catalog"),
    5: .standard(proto: "fk_db_schema"),
    6: .standard(proto: "fk_table"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self._pkCatalog) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._pkDbSchema) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.pkTable) }()
      case 4: try { try decoder.decodeSingularStringField(value: &self._fkCatalog) }()
      case 5: try { try decoder.decodeSingularStringField(value: &self._fkDbSchema) }()
      case 6: try { try decoder.decodeSingularStringField(value: &self.fkTable) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._pkCatalog {
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._pkDbSchema {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    if !self.pkTable.isEmpty {
      try visitor.visitSingularStringField(value: self.pkTable, fieldNumber: 3)
    }
    try { if let v = self._fkCatalog {
      try visitor.visitSingularStringField(value: v, fieldNumber: 4)
    } }()
    try { if let v = self._fkDbSchema {
      try visitor.visitSingularStringField(value: v, fieldNumber: 5)
    } }()
    if !self.fkTable.isEmpty {
      try visitor.visitSingularStringField(value: self.fkTable, fieldNumber: 6)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_CommandGetCrossReference, rhs: Arrow_Flight_Protocol_Sql_CommandGetCrossReference) -> Bool {
    if lhs._pkCatalog != rhs._pkCatalog {return false}
    if lhs._pkDbSchema != rhs._pkDbSchema {return false}
    if lhs.pkTable != rhs.pkTable {return false}
    if lhs._fkCatalog != rhs._fkCatalog {return false}
    if lhs._fkDbSchema != rhs._fkDbSchema {return false}
    if lhs.fkTable != rhs.fkTable {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_ActionCreatePreparedStatementRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActionCreatePreparedStatementRequest"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "query"),
    2: .standard(proto: "transaction_id"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.query) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self._transactionID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.query.isEmpty {
      try visitor.visitSingularStringField(value: self.query, fieldNumber: 1)
    }
    try { if let v = self._transactionID {
      try visitor.visitSingularBytesField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_ActionCreatePreparedStatementRequest, rhs: Arrow_Flight_Protocol_Sql_ActionCreatePreparedStatementRequest) -> Bool {
    if lhs.query != rhs.query {return false}
    if lhs._transactionID != rhs._transactionID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_SubstraitPlan: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SubstraitPlan"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "plan"),
    2: .same(proto: "version"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.plan) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.version) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.plan.isEmpty {
      try visitor.visitSingularBytesField(value: self.plan, fieldNumber: 1)
    }
    if !self.version.isEmpty {
      try visitor.visitSingularStringField(value: self.version, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_SubstraitPlan, rhs: Arrow_Flight_Protocol_Sql_SubstraitPlan) -> Bool {
    if lhs.plan != rhs.plan {return false}
    if lhs.version != rhs.version {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_ActionCreatePreparedSubstraitPlanRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActionCreatePreparedSubstraitPlanRequest"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "plan"),
    2: .standard(proto: "transaction_id"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._plan) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self._transactionID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._plan {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._transactionID {
      try visitor.visitSingularBytesField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_ActionCreatePreparedSubstraitPlanRequest, rhs: Arrow_Flight_Protocol_Sql_ActionCreatePreparedSubstraitPlanRequest) -> Bool {
    if lhs._plan != rhs._plan {return false}
    if lhs._transactionID != rhs._transactionID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_ActionCreatePreparedStatementResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActionCreatePreparedStatementResult"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "prepared_statement_handle"),
    2: .standard(proto: "dataset_schema"),
    3: .standard(proto: "parameter_schema"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.preparedStatementHandle) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self.datasetSchema) }()
      case 3: try { try decoder.decodeSingularBytesField(value: &self.parameterSchema) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.preparedStatementHandle.isEmpty {
      try visitor.visitSingularBytesField(value: self.preparedStatementHandle, fieldNumber: 1)
    }
    if !self.datasetSchema.isEmpty {
      try visitor.visitSingularBytesField(value: self.datasetSchema, fieldNumber: 2)
    }
    if !self.parameterSchema.isEmpty {
      try visitor.visitSingularBytesField(value: self.parameterSchema, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_ActionCreatePreparedStatementResult, rhs: Arrow_Flight_Protocol_Sql_ActionCreatePreparedStatementResult) -> Bool {
    if lhs.preparedStatementHandle != rhs.preparedStatementHandle {return false}
    if lhs.datasetSchema != rhs.datasetSchema {return false}
    if lhs.parameterSchema != rhs.parameterSchema {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_ActionClosePreparedStatementRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActionClosePreparedStatementRequest"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "prepared_statement_handle"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.preparedStatementHandle) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.preparedStatementHandle.isEmpty {
      try visitor.visitSingularBytesField(value: self.preparedStatementHandle, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_ActionClosePreparedStatementRequest, rhs: Arrow_Flight_Protocol_Sql_ActionClosePreparedStatementRequest) -> Bool {
    if lhs.preparedStatementHandle != rhs.preparedStatementHandle {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_ActionBeginTransactionRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActionBeginTransactionRequest"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_ActionBeginTransactionRequest, rhs: Arrow_Flight_Protocol_Sql_ActionBeginTransactionRequest) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_ActionBeginSavepointRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActionBeginSavepointRequest"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "transaction_id"),
    2: .same(proto: "name"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.transactionID) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.name) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.transactionID.isEmpty {
      try visitor.visitSingularBytesField(value: self.transactionID, fieldNumber: 1)
    }
    if !self.name.isEmpty {
      try visitor.visitSingularStringField(value: self.name, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_ActionBeginSavepointRequest, rhs: Arrow_Flight_Protocol_Sql_ActionBeginSavepointRequest) -> Bool {
    if lhs.transactionID != rhs.transactionID {return false}
    if lhs.name != rhs.name {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_ActionBeginTransactionResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActionBeginTransactionResult"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "transaction_id"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.transactionID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.transactionID.isEmpty {
      try visitor.visitSingularBytesField(value: self.transactionID, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_ActionBeginTransactionResult, rhs: Arrow_Flight_Protocol_Sql_ActionBeginTransactionResult) -> Bool {
    if lhs.transactionID != rhs.transactionID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_ActionBeginSavepointResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActionBeginSavepointResult"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "savepoint_id"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.savepointID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.savepointID.isEmpty {
      try visitor.visitSingularBytesField(value: self.savepointID, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_ActionBeginSavepointResult, rhs: Arrow_Flight_Protocol_Sql_ActionBeginSavepointResult) -> Bool {
    if lhs.savepointID != rhs.savepointID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_ActionEndTransactionRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActionEndTransactionRequest"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "transaction_id"),
    2: .same(proto: "action"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.transactionID) }()
      case 2: try { try decoder.decodeSingularEnumField(value: &self.action) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.transactionID.isEmpty {
      try visitor.visitSingularBytesField(value: self.transactionID, fieldNumber: 1)
    }
    if self.action != .unspecified {
      try visitor.visitSingularEnumField(value: self.action, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_ActionEndTransactionRequest, rhs: Arrow_Flight_Protocol_Sql_ActionEndTransactionRequest) -> Bool {
    if lhs.transactionID != rhs.transactionID {return false}
    if lhs.action != rhs.action {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_ActionEndTransactionRequest.EndTransaction: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "END_TRANSACTION_UNSPECIFIED"),
    1: .same(proto: "END_TRANSACTION_COMMIT"),
    2: .same(proto: "END_TRANSACTION_ROLLBACK"),
  ]
}

extension Arrow_Flight_Protocol_Sql_ActionEndSavepointRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActionEndSavepointRequest"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "savepoint_id"),
    2: .same(proto: "action"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.savepointID) }()
      case 2: try { try decoder.decodeSingularEnumField(value: &self.action) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.savepointID.isEmpty {
      try visitor.visitSingularBytesField(value: self.savepointID, fieldNumber: 1)
    }
    if self.action != .unspecified {
      try visitor.visitSingularEnumField(value: self.action, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_ActionEndSavepointRequest, rhs: Arrow_Flight_Protocol_Sql_ActionEndSavepointRequest) -> Bool {
    if lhs.savepointID != rhs.savepointID {return false}
    if lhs.action != rhs.action {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_ActionEndSavepointRequest.EndSavepoint: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "END_SAVEPOINT_UNSPECIFIED"),
    1: .same(proto: "END_SAVEPOINT_RELEASE"),
    2: .same(proto: "END_SAVEPOINT_ROLLBACK"),
  ]
}

extension Arrow_Flight_Protocol_Sql_CommandStatementQuery: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CommandStatementQuery"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "query"),
    2: .standard(proto: "transaction_id"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.query) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self._transactionID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.query.isEmpty {
      try visitor.visitSingularStringField(value: self.query, fieldNumber: 1)
    }
    try { if let v = self._transactionID {
      try visitor.visitSingularBytesField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_CommandStatementQuery, rhs: Arrow_Flight_Protocol_Sql_CommandStatementQuery) -> Bool {
    if lhs.query != rhs.query {return false}
    if lhs._transactionID != rhs._transactionID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_CommandStatementSubstraitPlan: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CommandStatementSubstraitPlan"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "plan"),
    2: .standard(proto: "transaction_id"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._plan) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self._transactionID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._plan {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._transactionID {
      try visitor.visitSingularBytesField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_CommandStatementSubstraitPlan, rhs: Arrow_Flight_Protocol_Sql_CommandStatementSubstraitPlan) -> Bool {
    if lhs._plan != rhs._plan {return false}
    if lhs._transactionID != rhs._transactionID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_TicketStatementQuery: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".TicketStatementQuery"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "statement_handle"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.statementHandle) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.statementHandle.isEmpty {
      try visitor.visitSingularBytesField(value: self.statementHandle, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_TicketStatementQuery, rhs: Arrow_Flight_Protocol_Sql_TicketStatementQuery) -> Bool {
    if lhs.statementHandle != rhs.statementHandle {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_CommandPreparedStatementQuery: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CommandPreparedStatementQuery"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "prepared_statement_handle"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.preparedStatementHandle) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.preparedStatementHandle.isEmpty {
      try visitor.visitSingularBytesField(value: self.preparedStatementHandle, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_CommandPreparedStatementQuery, rhs: Arrow_Flight_Protocol_Sql_CommandPreparedStatementQuery) -> Bool {
    if lhs.preparedStatementHandle != rhs.preparedStatementHandle {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_CommandStatementUpdate: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CommandStatementUpdate"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "query"),
    2: .standard(proto: "transaction_id"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.query) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self._transactionID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.query.isEmpty {
      try visitor.visitSingularStringField(value: self.query, fieldNumber: 1)
    }
    try { if let v = self._transactionID {
      try visitor.visitSingularBytesField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_CommandStatementUpdate, rhs: Arrow_Flight_Protocol_Sql_CommandStatementUpdate) -> Bool {
    if lhs.query != rhs.query {return false}
    if lhs._transactionID != rhs._transactionID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_CommandPreparedStatementUpdate: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CommandPreparedStatementUpdate"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "prepared_statement_handle"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.preparedStatementHandle) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.preparedStatementHandle.isEmpty {
      try visitor.visitSingularBytesField(value: self.preparedStatementHandle, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_CommandPreparedStatementUpdate, rhs: Arrow_Flight_Protocol_Sql_CommandPreparedStatementUpdate) -> Bool {
    if lhs.preparedStatementHandle != rhs.preparedStatementHandle {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_DoPutUpdateResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".DoPutUpdateResult"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "record_count"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.recordCount) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.recordCount != 0 {
      try visitor.visitSingularInt64Field(value: self.recordCount, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_DoPutUpdateResult, rhs: Arrow_Flight_Protocol_Sql_DoPutUpdateResult) -> Bool {
    if lhs.recordCount != rhs.recordCount {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_ActionCancelQueryRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActionCancelQueryRequest"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "info"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.info) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.info.isEmpty {
      try visitor.visitSingularBytesField(value: self.info, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_ActionCancelQueryRequest, rhs: Arrow_Flight_Protocol_Sql_ActionCancelQueryRequest) -> Bool {
    if lhs.info != rhs.info {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_ActionCancelQueryResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActionCancelQueryResult"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "result"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.result) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.result != .unspecified {
      try visitor.visitSingularEnumField(value: self.result, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Arrow_Flight_Protocol_Sql_ActionCancelQueryResult, rhs: Arrow_Flight_Protocol_Sql_ActionCancelQueryResult) -> Bool {
    if lhs.result != rhs.result {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Arrow_Flight_Protocol_Sql_ActionCancelQueryResult.CancelResult: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "CANCEL_RESULT_UNSPECIFIED"),
    1: .same(proto: "CANCEL_RESULT_CANCELLED"),
    2: .same(proto: "CANCEL_RESULT_CANCELLING"),
    3: .same(proto: "CANCEL_RESULT_NOT_CANCELLABLE"),
  ]
}
